<?php
// file.php - data management for a file with subtasks
// ------------------------------------------------------------------------
// Copyright (c) 2007 Jerome Nivard
// Copyright (c) 2015 Denis Guinnepain
// ------------------------------------------------------------------------
// This file is part of Diamentis

// Diamentis is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// Diamentis is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with phpBugTracker; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// ------------------------------------------------------------------------

if ( !defined('INC_FILE_FILE') ) {
      define ('INC_FILE_FILE',1);

include('Inc/Classes/bo/task.php');

class File
{
  var $id;
  var $dateCreation;
  var $domain;
  var $title;
  var $description;
  var $initLoad;
  var $raf;
  var $used;
  var $tab_task;
  var $tabActivity;
        
function File($id=-1) {
  $this->id  = $id;
}

function HasTask( $taskDescID ) {
  $countElem = count($this->tab_task);
  //Printf("<br>nb elem : $countElem");
  If (0<$countElem) {
    foreach($this->tab_task As $task) {
      if ($task->idTaskDesc == $taskDescID) {
	$ret=$task;
	break;
      }
    }
  }
  return $ret;
}

// $mdb2 is the calendar DB
function GetActivities( &$mdb2 ) {
 foreach($this->tab_task As $task) {
   $task->GetActivities($mdb2);
 }
}
	
// $mdb2 is the calendar DB
function LoadActivitiesFromDB(&$mdb2) {
  If ($this->id<>NULL) {
    $cpt=0;
    $lstCalNames = "";
    foreach ($this->tab_task As $oTask) {
      $cpt = $cpt + 1;
      if (1<$cpt) {
        $lstCalNames = $lstCalNames.", ";
      }
      $lstCalNames=$lstCalNames."'". $oTask->id ."'";
      //$lstCalNames=$lstCalNames.$oTask->id;
    }
    $req="select * from webcal_entry,webcal_entry_user where cal_name in ( ".$lstCalNames." ) and webcal_entry_user.cal_id=webcal_entry.cal_id and webcal_entry_user.cal_status<>'D' order by cal_date, cal_time";
    $result=mysql_query($req,$mdb2);
    if ($result==false) {
      printf("<br>La requte $req a chou !");
    } else {
       $rows=mysql_num_rows($result);
       $this->used=0;
       While ($data=mysql_fetch_object($result)) {
          $this->used=$this->used + $data->cal_duration;
          $activity=new Activity;
          $activity->id=$data->cal_id;
          $activity->loadFromDbData($data);
          $this->tabActivity[]=$activity;
       }
        //If (0<$rows) {
  	//	  printf("<br>Total used = $this->used min");
        //	}
       mysql_free_result($result);
      }
  }
  return $ret;
}		
      	

function SearchDomain(&$mdb2) {
  $ret=-1;
  $req="select project_id from " . DB_TBL_PREFIX ."file_index where bug_id=".$this->id;
  $result=mysql_query($req,$mdb2);
  if ($result==false) {
    printf("La requete $req a echoue !");
  } else {
    if ($data=mysql_fetch_object($result)) {
	$ret=$data;
    }
  }
  return $ret;
}

  /**
    * Charge les attributs de l'objet depuis la BDD.
    * @param db
    *      Rfrence  la BDD.
    */
  function load( &$mdb2 )
  {
    $ret=-1;
    if ($this->domain=="") {
//printf("<br>SearchDomain() = %d",$this->SearchDomain($mdb2 ));
	$this->domain=$this->SearchDomain($mdb2 );
    }
    $req="select * from " . DB_TBL_PREFIX . "file_prj_id_".$this->domain." where bug_id=".$this->id;
    $result=mysql_query($req,$mdb2);
    if ($result==false) {
	Printf("<br>La requete $req a chou !");
      $ret=-1;
    } else {
      $data=mysql_fetch_object($result);
      //$this->dateCreation =$data->dateCreation;
      $this->title =$data->title;
      $this->description =$data->description;
      $this->dateCreation =$data->created_date;
      $ret=$this->id;
    }
    return $ret;
  }

  function loadTasks(&$mdb2)
  {
    $ret=0;
    $req="select * from " . TBL_PREFIX . "task where idFD=$this->id order by id";
    $result=mysql_query($req,$mdb2);
    if ($result==false) {
      $ret=-1;
    } 
    else {
	  $cpt = 0;
	  $this->initLoad=0;
	  $this->raf=0;
	  $this->used=0;
	  
      while ($data=mysql_fetch_object($result)) {
      	$task = new Task;
		$task->id = $data->id;
        $task->file = $this;
		$task->idFD = $this->id;	
		$task->Load($mdb2);
		$this->initLoad=$this->initLoad + $task->initLoad;
		$this->raf		 =$this->raf 			+ $task->raf;
		$this->used		 =$this->used 		+ $task->used;
		$this->tab_task[$cpt] = $task;
		$cpt = $cpt + 1;
	  }
    }
    return $ret;
  }	
	
  function CalculateInitLoad( &$mdb2 )
  {
    $ret=0;
    $req="select * from " . TBL_PREFIX . "task where idFD=$this->id";
    $result=mysql_query($req,$mdb2);
    if ($result==false) {
      $ret=-1;
    } else {
      while ($data=mysql_fetch_object($result)) {
      $ret=$ret + $data->initLoad;
			}
    }
    return $ret;
  }	

  function CalculateUsed( &$mdb2 )
  {
    $ret=0;
    $req="select * from " . TBL_PREFIX . "task where idFD=$this->id";
    $result=mysql_query($req,$mdb2);
    if ($result==false) {
      $ret=-1;
    } else {
      while ($data=mysql_fetch_object($result)) {
      $ret=$ret + $data->used;
			}
    }
    return $ret;
  }	
		
  /**
    * Charge la liste des fiches depuis la BDD.
    * @param db
    *      Rfrence  la BDD.
    */
  function loadList( &$mdb2, &$tab, $ordreCol, $ordreSens )
  {
    $ret=-1;
    $req="select distinct id from Files order by ";
    if ($ordreCol=="") {
      $ordreCol="nom";
    }
    if ($ordreSens=="ASC") {
      $ordreSens="DESC";
    } else {
      $ordreSens="ASC";
    }

    $req.="$ordreCol";
    $req.=" $ordreSens";

    $result=mysql_query($req,$mdb2);
    if ($result==false) {
      $ret=-1;
    } else {
      $i=0;
      while ($data=mysql_fetch_object($result)) {
        $tab[]=new Centrale;
        $tab[$i]->initAttributes();
        $tab[$i]->id=$data->id;
        $tab[$i]->load($mdb2);
        $i++;
      }
      $ret=$i;
    }
    return $ret;
  }

  /**
    *
    * @param db
    *      Rfrence  la BDD.
    */
  function save( &$mdb2 )
  {
    $ret=-1;

      $req="update Files set nom='".$this->nom."',
			dateCreation='".$this->dateCreation."'";
      addNumberToReqUpdate($req,'idEntreprise',$this->entreprise);
      $req.=" where id=".$this->id;

    //printf($req);
    $result=mysql_query($req,$mdb2);
    if ($result==false) {
      printf("La requte $req a chou !");
      $ret=-1;
    }
    //mysql_free_result($result);
    return $ret;
  }

  /**
    * initAttributes sets all Entreprise attributes to its default
    * value make sure to call this method within your class constructor
    */
  function initAttributes( )
  {
    $this->id  = -1;
  }

}

} // ifndef
?>
