<?php
// ihmfile.php - display functions and classes for subtasks of a file
// ------------------------------------------------------------------------
// Copyright (c) 2007 Jerome Nivard
// Copyright (c) 2015 Denis Guinnepain
// ------------------------------------------------------------------------
// This file is part of Diamentis

// Diamentis is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// Diamentis is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with phpBugTracker; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// ------------------------------------------------------------------------

if ( !defined('INC_FILE_IHM_FILE') ) {
      define ('INC_FILE_IHM_FILE',1);

include_once('Inc/FctDivers.php');
include_once('Inc/Classes/bo/file.php');
include_once('Inc/Classes/bo/task.php');
include_once('Inc/Classes/ihm/ihmtask.php');
include_once('Inc/Page.php');
include_once('Inc/ConstantesDB.php');
include_once('Inc/Classes/bo/taskDescription.php');

class IHMFile
{

function show(&$mdb2, $obj) {
    $ret=-1;
    $dateCreation=MySQLDateToExplicitDate($obj->dateCreation);
    printf("
		<p>File ".$obj->id."</p>
    <table>
    <tr><td>description</td><td>".$obj->description."</td></tr>");
    printf("
    </table>");
    return $ret;
}

function ShowMessages(&$file, &$tabDesc) {
 printf("\n<p><font size=\"5\" color=\"blue\"><a href=\"saisie_temps.php?idFD=%d&domain=%d\">File %d</a> : %s</font></p>",$file->id, $_GET["domain"], $file->id, $file->title);
// printf("\n<p><font size=\"4\" color=\"brown\">(Initial estimated load : %sh )</font>",$file->initLoad);
// printf("\n<font size=\"4\" color=\"green\"> -- ( raf : %sh )</font>",$file->raf);
// printf("\n<font size=\"4\" color=\"red\"> -- ( used : %s )</font></p>",ConvertMinToHoursAndMin($file->used));
$curUsed=0;
if (0<$file->used) {
  $curUsed=ConvertMinToHoursAndMin($file->used);
}
 printf("\n<font size=\"4\" color=\"red\">Used : %s</font></p>",$curUsed);

 if (is_array($file->tabActivity)) {
   $objDesc = new TaskDescription;
   foreach($file->tabActivity as $activity) {
     $index= $objDesc->GetFromID($tabDesc,$activity->GetTaskDesc());
     printf("\n<p>");
     printf("<font color=\"brown\">%s</font>", $activity->user);
     printf("<font color=\"red\"> : %s</font>", $tabDesc[$index]->title);
     printf("<br><a href=\"../WebCalendar/day.php?date=$activity->date\">%s</a> ", DateToExplicitDate($activity->date));
     printf("<font color=\"green\"> %s </font>", TimeToExplicitTime($activity->timeBegin));
     printf("<font color=\"blue\"> - Duration : %s </font>", ConvertMinToHoursAndMin($activity->used));
     printf("\n<br>$activity->msg\n");
     printf("</p>");
   }
 }
}	
	
function Modif1( &$mdb2,  &$obj, $tabTaskDesc )
  {
    $tabDate=explode('-',$obj->dateCreation);
		$taskIHM = New IHMTask;
    printf("
    <p><font size=\"5\" color=\"BLUE\"><a href=\"FileMessages.php?id=%d&domain=%d\">File %s : %s</a></font>
    </p>",$obj->id,$obj->domain,$obj->id, $obj->title);
    $this->Modif2($mdb2, $obj, $tabTaskDesc);
  }
  
function Modif2( &$mdb2,  &$obj, $tabTaskDesc )
  {
    printf("
    <table>
		<caption>File $obj->id</caption>
		<theader>
		<th width=\"%s\">Initial estimated load</th><th width=\"%s\">R.A.F.</th><th width=\"%s\">Used</th></th><th colspan=\"5\" width=\"%s\">General task decomposition</th>
		</theader>
		<tbody>"
		, "10%", "10%", "10%", "70%");
		printf("
		<tr  bgcolor=\"#FF00FF\"><td>Total: $obj->initLoad</td><td>Total: $obj->raf</td><td>Total:$obj->used</td>");	
    $this->Modif3($mdb2, $obj, $tabTaskDesc);
  }
		
function Modif3( &$mdb2,  &$obj, $tabTaskDesc )
		{
		
  		$this->Modif4($mdb2,  $obj);
  		printf("
		</tbody>
		</table>
   		<table>
		");
  		foreach($tabTaskDesc as $taskDesc) {
		  $bgColor = "#FFFFFF";
			$task = $obj->HasTask($taskDesc->id);
			If (isset($task)	) {
  		 		 $bgColor = "#e0FFFF";
			
  				  $this->Modif5($mdb2,  $obj, $task, $taskDesc, $bgColor);
				} 	
			}
  		$task = new Task;
  		$bgColor = "#dcdcdc";
  		$taskDesc = new taskDescription;
  		$this->Modif5($mdb2,  $obj, $task, $taskDesc, $bgColor);
	
  		printf("
  				</table>");  		
  }
  
  function Modif4( &$mdb2,  &$obj )
  {
  	printf("
  			<td width=\"%s\">Title </td><td width=\"%s\"> Description </td><td width=\"%s\" >name</td><td width=\"%s\" >Type</td><td width=\"%s\" >Group</td></tr>"
  			, "10%", "30%", "10%", "10%", "10%");
  }
  
  function Modif5( &$mdb2,  &$obj,$task, $taskDesc, $bgColor )
  {
  	printf("
   			<tr><td><form action=\"SaveTemps.php?idFD=$obj->id&domain=$obj->domain\" method=\"post\"><table><tr>
  			<td width=\"0\"><INPUT TYPE=\"hidden\" NAME=\"taskDescId\"  size=\"0\" VALUE=\"%s\"></td>",
   			$taskDesc->id);
   			printf("<td><INPUT TYPE=\"TEXT\" NAME=\"initLoad\" size=\"15\"  VALUE=\"%s\"></td>
   					<td><INPUT TYPE=\"TEXT\" NAME=\"raf\" size=\"16\"  VALUE=\"%s\"></td>
   					<td><INPUT TYPE=\"TEXT\" NAME=\"used\" size=\"16\"  VALUE=\"%s\"></td>
   					<td><INPUT TYPE=\"TEXT\" NAME=\"title\" size=\"16\"  VALUE=\"%s\"></td>
   					<td><INPUT TYPE=\"TEXT\" NAME=\"description\" size=\"58\" VALUE=\"%s\"></td>
   					<td><INPUT TYPE=\"TEXT\" NAME=\"name\" size=\"16\"  VALUE=\"%s\"></td>
   					<td><INPUT TYPE=\"TEXT\" NAME=\"type\" size=\"16\"  VALUE=\"%s\"></td>
   					<td><INPUT TYPE=\"TEXT\" NAME=\"group\"  size=\"16\" VALUE=\"%s\"></td>",
  					$task->initLoad, $task->raf, $task->used, $taskDesc->title, $taskDesc->description,
   					$taskDesc->name, $taskDesc->type, $taskDesc->group);
	    printf("\n<td><input type=\"submit\" value=\"Save\" /></td>
    </tr></table></form></td></tr>");
  }
  
  
  function showList(&$tab, $ordreCol, $ordreSens)
  {
    if ($ordreCol=='') {
      $ordreCol=FORM_CEN_NOM;
    }
    if ($ordreSens=="ASC") {
      $ordreSens="DESC";
      $imgOrdre=PATH_IMAGES_DIVERS.'fleche17.gif';
    } else {
      $ordreSens="ASC";
      $imgOrdre=PATH_IMAGES_DIVERS.'fleche16.gif';
    }
    printf("\n<div class=\snpiet-liste\">
    <table summary=\"Centrales du SNPIET\">
    <caption>".count($tab)." centrales enregistres sur le site du SNPIET</caption>
    <th>Photo</th>
    <th><a href=\"".FILE_CENTRALES."?OrdreCol=".FORM_CEN_NOM."&OrdreSens=$ordreSens\"><img src=\"$imgOrdre\" alt=\"fleche\"/>Nom</a></th>
    <th><a href=\"".FILE_CENTRALES."?OrdreCol=".FORM_CEN_VILLE."&OrdreSens=$ordreSens\"><img src=\"$imgOrdre\" alt=\"fleche\"/>Ville</a></th>
    <th>T&eacute;l.</th>
    <th>Puissance (mW)</th>");
    $colorFondAdd=0;
    $puissanceTotale=0;
    foreach ($tab as $centrale) {
      $dateCreation=MySQLDateToExplicitDate($centrale->dateCreation);
      $colorFondAdd=1-$colorFondAdd;
      printf("\n\t<tr class=\"ligne$colorFondAdd\">
        <td><a href=\"".FILE_CENTRALE."?id=".$centrale->id."\"><img class=\"imagette\" src=\"$srcImg\" alt=\"Photo de ".$centrale->nom."\"/></a></td>");
      printf("<td><a href=\"".FILE_CENTRALE."?id=".$centrale->id."\">".$centrale->nom."</a></td>
        <td>".$centrale->ville."</td>
        <td>".$centrale->telephone."</td>
        <td>".$centrale->puissance."</td>");
      printf("</tr>");
      $puissanceTotale+=$centrale->puissance;
    }
    printf("<tr><td>Total</td><td></td><td></td><td></td><td>$puissanceTotale</td></tr>");
    printf("</table>");
    if ($_SESSION[SESS_USER_DROITS]==DROITS_MODIF) {
      printf("</form>
      <form method=\"post\" action=\"".FILE_CENTRALE_MODIF."?id=-1\">
      <input type=\"submit\" value=\"Ajouter une centrale\" />
      </form>");
    }
    printf("</div>");
  }

} // class

function displayTasks($mdb2){

	//$identifier->login=$_POST['login'];
	debut();
	debutContenu();
	$file = new File;
	$file->id = $_GET['id'];
	$file->domain = $_GET['domain'];
	$file->load($mdb2);
	$file->loadTasks($mdb2);
	$taskDesc = new taskDescription;
	$taskDesc->loadList($mdb2, $tabTaskDesc,$file->tab_task);
	$fileIHM = new IHMfile;
	$fileIHM->Modif1($mdb2, $file, $tabTaskDesc);
	finContenu();
	fin();
}

} // ifndef
?>
