<?php
// FctDivers.php - display subtasks
// ------------------------------------------------------------------------
// Copyright (c) 2007 Jerome Nivard
// ------------------------------------------------------------------------
// This file is part of Diamentis

// Diamentis is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// Diamentis is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with phpBugTracker; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// ------------------------------------------------------------------------

if ( !defined('INC_FILE_FCT_DIVERS') ) {

define('INC_FILE_FCT_DIVERS',1);
include("Inc/ConstantesDB.php");

Function ConvertMinToHours($minTotal) {
  If ($minTotal<>'') {
    $hours=number_format($minTotal/60,2);
    $hoursAndMin=$hours."h";
	}
  return $hoursAndMin;
}

Function ConvertMinToHoursAndMin($minTotal) {
  If ($minTotal<>'') {
    $hours=number_format(floor($minTotal/60),0);
		$min=sprintf('%02d',$minTotal-60*$hours);
    $hoursAndMin=$hours."h".$min;
	}
  return $hoursAndMin;
}


Function MySQLDateToExplicitDate($MyDate, $WeekDayOn=0, $YearOn=1)
{
  $MyMonths = array("Janvier", "Fvrier", "Mars", "Avril", "Mai", "Juin",
        "Juillet", "Aot", "Septembre", "Octobre", "Novembre", "Dcembre");
  $MyDays = array("Dimanche", "Lundi", "Mardi", "Mercredi", "Jeudi",
                  "Vendredi", "Samedi");

  $DF=explode('-',$MyDate);
  $TheDay=getdate(mktime(0,0,0,$DF[1],$DF[2],$DF[0]));

  $MyDate=$DF[2]." ".$MyMonths[$DF[1]-1];
  if($WeekDayOn){$MyDate=$MyDays[$TheDay["wday"]]." ".$MyDate;}
  if($YearOn){$MyDate.=" ".$DF[0];}

  return $MyDate;
}

Function DateToExplicitDate($MyDate, $WeekDayOn=0, $YearOn=1)
{
  $MyMonths = array("Janvier", "Fvrier", "Mars", "Avril", "Mai", "Juin",
        "Juillet", "Aot", "Septembre", "Octobre", "Novembre", "Dcembre");
  $MyDays = array("Dimanche", "Lundi", "Mardi", "Mercredi", "Jeudi",
                  "Vendredi", "Samedi");

  $DF[0]=subStr($MyDate,0,4);
  $DF[1]=subStr($MyDate,4,2);
  $DF[2]=subStr($MyDate,6,2);
  $TheDay=getdate(mktime(0,0,0,$DF[1],$DF[2],$DF[0]));

  $MyDate=$DF[2]." ".$MyMonths[$DF[1]-1];
  if($WeekDayOn){$MyDate=$MyDays[$TheDay["wday"]]." ".$MyDate;}
  if($YearOn){$MyDate.=" ".$DF[0];}

  return $MyDate;
}

Function TimeToExplicitTime($MyTime)
{
  $DF[0]=subStr($MyTime,0,2);
  $DF[1]=subStr($MyTime,2,2);
  //$DF[2]=subStr($MyTime,4,2);

  //return $DF[0]."h".$DF[1]."m".$DF[2]."s";
  return $DF[0]."h".$DF[1];
}

function addNumberToReqUpdate(&$req,$nom,&$valeur) {
  if ($valeur=='') {
    $req.=", $nom=NULL ";
  } else {
    $req.=", $nom=".$valeur;
  }
}

function addNumberToReqInsert(&$reqNames,&$reqValues,$nom,&$valeur) {
  if (!is_null($valeur)) {
    if ($valeur!='') {
      $reqNames.=", $nom ";
      $reqValues.=", $valeur ";
    }
  }
}

function validation_date($date){
 /* Fonction gnrale de vrification */

 /* controle de la longueur de la chaine jj/mm/aaaa = 10 */
 if(strlen($date)==10){
  if(substr($date,2,1)=="/" && substr($date,5,1)=="/"){
    /* les caractres 1 et 6 sont des " / "  */
    $jour=intval(substr($date,0,2)); /* PHP numrote les chaines depui
s 0 */
    $mois=intval(substr($date,3,2));
    $annee=intval(substr($date,6,4));
    if($mois>=1 && $mois<=12){  /* verifie que le mois verifie 1<mois<
12 */
     if($jour<=longueurMois($mois,$annee)){ /* controle le jour par */

      return true;                        /* rapport a la longueur du 
mois */
     }
     else {
      return false;
     }
    }
    else {
     return false;
    }
   }
   else {
    return false;
   }
  }
  else {
   return false;
  }
 }

 /* La fonction renvoit la longueur d'un mois prcis */
 /* en tenant compte du mois de fvrier et des annes bissextiles */

 function longueurMois($mois,$annee){
  if ($mois==4 || $mois==6 || $mois==9 || $mois==11) return 30;
   else if (($mois==2) && estBissextile($annee)) return 29;
   else if ($mois==2) return 28;
   else return 31;
  }

  /* Les annes bissextiles sont les annes paires divisibles par
     quatre et qui ne sont pas des anne de centaine et les annes
     de centaine qui sont divisibles par 400.
     (par exemple 1600 tait bissextile, 2000 aussi mais pas 1900
      qui est divisible par 4 et paire mais pas divisible par 400) */

 /* fonction appele par validation_date() */

 function estBissextile($ans){
  if ((($ans % 4 == 0) && $ans % 100 != 0) || $ans % 400 == 0)
   return true;/*c'est une anne bissextile */
  else
   return false;/*ce n'en est pas une */
 }

/*
   function verifiermail(mail) {
      if ((mail.indexOf("@")>=0)&&(mail.indexOf(".")>=0)) {
         return true
      } else {
         alert("Mail invalide !");
         return false
      }
   }
   */

  function addWhere(&$where,$str,$method='and')
  {
    if ($where=='') {
      $where=' where ';
    } else {
      $where.=' '.$method.' ';
    }
    $where.=$str;
  }

  function arrayIntersection(&$tab1,&$tab2,&$tabRes)
  {
    foreach($tab1 as $elem) {
      //if ( in_array($elem,$tab2) ) {
      foreach ($tab2 as $elem2) {
        if ($elem===$elem2) {
          $tabRes[]=$elem;
          break;
        }
      }
    }
  }

  function getObjById(&$tab,$id,&$obj)
  {
    $ret=-1;
    foreach ($tab as $elem) {
      if ($elem->id==$id) {
        $obj=$elem;
        $ret=1;
      }
    }
    return $ret;
   }
   
} // ifndef
?>
