<?php
// Savetemps.php - record subtask data
// ------------------------------------------------------------------------
// Copyright (c) 2007 Jerome Nivard
// Copyright (c) 2015 Denis Guinnepain
// ------------------------------------------------------------------------
// This file is part of Diamentis

// Diamentis is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// Diamentis is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with phpBugTracker; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// ------------------------------------------------------------------------

chdir("..");
include_once('include.php');
include_once('inc/func_html.inc.php');
chdir("Addons");
include_once('Inc/Page.php');
include_once('Inc/ConstantesDB.php');
include_once('Inc/Classes/bo/file.php');
include_once('Inc/Classes/bo/task.php');
include_once('Inc/Classes/ihm/ihmfile.php');

function save( &$mdb2, $idFD, $domain)
  {
	global $u;
  	$ret=-1;
		$file = New File;
		$file->id = $idFD;
		$file->domain = $domain;
		$file->load($mdb2);
		$file->loadTasks($mdb2);
		
		//usefull for propagateMPFile
		$project_id = MPFile::getProject_id($idFD);
		$mpfile = new MPFile($project_id);
		// get the original file data
		$original = $mpfile->getFile($idFD);
		$original = current($original);
		
		//printf("count(_POST[initLoad]) = %d", count($_POST["initLoad"]));
		$taskDesc = new TaskDescription($_POST["taskDescId"]);
		
		if ($_POST["taskDescId"]<>"-1"){
			$task = $file->HasTask($_POST["taskDescId"]);
    		$wasExisting=TRUE;
		}
		else {
				$wasExisting=FALSE;
			  // Si (l'un des champs<>0) alors crer la tache en BDD et l'initialiser
				$task = New Task;
				$task->idFD     = $idFD;
		}
		$data = array(
				'name' =>  $_POST['name'],
				'type' =>  $_POST['type'],
				'title' =>  $_POST['title'],
				'description' =>  $_POST['description'],
				'group' =>  $_POST['group']
				);
		$taskDesc->loadFromRstData($mdb2, $data);
		If (trim($_POST["initLoad"])=="" or trim($_POST["initLoad"])=='0') {$_POST["initLoad"]='';}
		$task->initLoad = $_POST["initLoad"];
		If (trim($_POST["raf"])=="" or trim($_POST["raf"])=='0') {$_POST["raf"]='';}
		$task->raf      = $_POST["raf"];
		If (trim($_POST["used"])=="" or trim($_POST["used"])=='0') {$_POST["used"]='';}
		$task->used     = $_POST["used"];
		If (0<$task->initLoad Or 0<$task->raf Or 0<$task->used) {
		  if ($wasExisting){
			$ret=$taskDesc->Update($mdb2);
		  }
		  else {
		  	$ret = $taskDesc->Save($mdb2);
		  }
		}
		If ($task->initLoad=="" And $task->raf=="" And $task->used=="" or trim($taskDesc->title)=="") {
			$ret=$task->Delete($mdb2); //it will also delete taskDesc
		}
		elseif ($ret <> -1){
		  if ($wasExisting){
		  	$task->idTaskDesc = $ret;
		  	$ret = $task->Update($mdb2);
		  }
		  else {
		  	$task->idTaskDesc = $ret;
		  	$ret = $task->Save($mdb2);
		  }
		}				
	
	propagateMPFile($mdb2,intval($idFD),intval($domain),$original);
		
	return $ret;
  }		
 
function propagateMPFile( &$mdb2, $id,$domain,$original){
	global $u;
	$file = New File;
	$file->id = $id;
	$file->domain = $domain;
	$file->load($mdb2);
	$file->loadTasks($mdb2);
	$project_id = MPFile::getProject_id($id);
	$mpfile = new MPFile($domain);
	$posted_values=array(
			'field_26'=>$file->initLoad,
			'field_27'=>$file->raf ,
			'field_28'=>$file->used 
	);
	
	$changed_fields = treat_dynamic_input_data($posted_values, $mpfile, $original, $verbose=false);
	$mpfile->updateFile($id, $changed_fields, $verbose);
	log_into_history($original, $changed_fields);
}
$temp = $u;
openDB($mdb2);

$ret = save($mdb2,intval($_GET['idFD']),$_GET['domain']);
if (0<=$ret) {
	printf("<p>Modifications saved.");
	redirection("Saisie_temps.php?id=". $_GET['idFD'] ."&domain=".$_GET['domain']);
} else {
	debut();
	debutContenu();
	
	printf("<br>An error occured. File %d not saved.", $_GET['idFD']);
	printf("<p><a href=\"Saisie_temps.php?idFD=%d&domain=%d\">Return to set times for file %d</a>", $_GET['idFD'], $_GET['domain'], $_GET['idFD']);
	
	finContenu();
	fin();
	
}
closeDB($mdb2);
