<?php

// attachment.php - Adding, deleting, and displaying attachments
// ------------------------------------------------------------------------
// Copyright (c) 2001, 2002 The phpBugTracker Group
// Copyright (c) 2004, 2005 David Han Sze Chuen, Denis Guinnepain for Air Liquide Medical Systems (Taema)
// Copyright (c) 2005, 2006, 2015 Denis Guinnepain
 
// ------------------------------------------------------------------------
// This file is part of Diamentis

// Diamentis is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// Diamentis is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with phpBugTracker; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// ------------------------------------------------------------------------
// $Id: attachment_lib.php,v 1.1.1.3 2006/01/14 23:44:20 denis Exp $

/**
Add an attachment file associated to a memento file
*/
function add_attachment($file_id, $description) {
	global $db, $now, $u, $STRING, $t;
	if (!isset($_FILES['attachment']) || 
		$_FILES['attachment']['tmp_name'] == 'none') {
		show_attachment_form($file_id, $STRING['give_attachment']);
		return;
	}

	// Check the upload size.  If the size was greater than the max in
	// php.ini, the file won't even be set and will fail at the check above
	if ($_FILES['attachment']['size'] > ATTACHMENT_MAX_SIZE) {
		show_attachment_form($file_id, $STRING['attachment_too_large']);
		return;
	}
	
	// get the project_id
	$project_id = MPFile::getProject_id($file_id);
	// get the its file table name
	$file_table_name = MPFile::getProjectData($project_id, 'file_table_name');
	
	if (!$project_id) {
	
	//DEBUG
	//println("test 1");
	
		show_text($STRING['nobug'], true);
		return;
	}

	//DEBUG
	//println("test 2");
	
	// Check for a previously-uploaded attachment with the same name, bug, and project
	$rs = $db->query("select a.bug_id, b.project_id from ".TBL_ATTACHMENT." a, ".
		TBL_FILE_INDEX ." b where file_name = '{$_FILES['attachment']['name']}' ".
		"and a.bug_id = b.file_id");
	while ($rs->fetchInto($ainfo)) {
		if ($file_id == $ainfo['bug_id'] && $project_id == $ainfo['project_id']) {
			show_attachment_form($file_id, $STRING['dupe_attachment']);
			return;
		}
	}
	
	$filepath = ATTACHMENT_PATH;
	$tmpfilename = $_FILES['attachment']['tmp_name'];
	$filename = "$file_id-{$_FILES['attachment']['name']}";

	if (!is_dir($filepath)) {
		show_attachment_form($file_id, $STRING['no_attachment_save_path']);
		return;
	}

	if (!is_writeable($filepath)) {
		show_attachment_form($file_id, $STRING['attachment_path_not_writeable']);
		return;
	}

	if (!is_dir("$filepath/$project_id")) {
		@mkdir("$filepath/$project_id", 0775);
	}

	if (!@move_uploaded_file($_FILES['attachment']['tmp_name'], "$filepath/$project_id/$filename")) {
		show_attachment_form($file_id, $STRING['attachment_move_error']);
		return;
	}

	@chmod("$filepath/$project_id/$filename", 0766);
	$db->query("insert into ".TBL_ATTACHMENT." (attachment_id, bug_id, file_name, ".
		"description, file_size, mime_type, created_by, created_date) values (".
		join(', ', array($db->nextId(TBL_ATTACHMENT), $file_id,
			$db->quote($_FILES['attachment']['name']), 
			$db->quote(stripslashes($description)), 
			$_FILES['attachment']['size'], 
			$db->quote($_FILES['attachment']['type']), $u, $now)).")");

	if ($_POST['use_js']) {
		$t->display('admin/edit-submit.html');
	} else {
		header("Location: bug.php?op=show&file_id=$file_id");
	}
} // end of add_attachment($file_id, $description)
/////////////////////////////////////////////////////////////////////////////////////////////////////
/**
	Delete an attachment file
*/
function del_attachment($attachid) {
	global $db, $HTTP_SERVER_VARS;
	
	if (list($filename, $mimetype) = grab_attachment($attachid)) {
		$db->query("delete from ".TBL_ATTACHMENT." where attachment_id = $attachid");
		unlink($filename);
		header("Location: {$HTTP_SERVER_VARS['HTTP_REFERER']}");
	}
} // end of del_attachment($attachid)
/////////////////////////////////////////////////////////////////////////////////////////////////////
/**
	Return the filename and mime type of an attachment file
*/
function grab_attachment($attachid) {
	global $db, $STRING;
	
	if (!is_numeric($attachid)) {
		show_text($STRING['bad_attachment'], true);
		return false;
	}
	$ainfo = $db->getRow("select a.bug_id, file_name, mime_type, project_id"
		." from ".TBL_ATTACHMENT." a, ".TBL_FILE_INDEX." b"
		." where attachment_id = $attachid and a.bug_id = b.file_id");
	if (empty($ainfo)) {
		show_text($STRING['bad_attachment'], true);
		return false;
	}
	$filename = join('/',array(ATTACHMENT_PATH, 
		$ainfo['project_id'], "{$ainfo['bug_id']}-{$ainfo['file_name']}"));
	if (!is_readable($filename)) {
		show_text($STRING['bad_attachment'], true);
		return false;
	}
	return array($filename, $ainfo['mime_type']);
} // end of grab_attachment($attachid)
/////////////////////////////////////////////////////////////////////////////////////////////////////
/**
	prepare attachment form
*/
function show_attachment_form($file_id, $error = '') {
	global $db, $t, $STRING;
	
	if (!is_numeric($file_id)) { 
		show_text($STRING['nobug'], true);
		return;
	}
	
	$file_exists = $db->getOne("select count(*) from ".TBL_FILE_INDEX ." where file_id = $file_id");
	if (!$file_exists) { 
		show_text($STRING['nobug'], true);
		return;
	}
	
	$t->assign(array(
		'error' => $error,
		'file_id' => $file_id,
		'description' => isset($description) 
			? htmlspecialchars(stripslashes($description)) : '',
		'max_size' => ini_get('upload_max_filesize') < ATTACHMENT_MAX_SIZE 
			? number_format(ini_get('upload_max_filesize'))
			: number_format(ATTACHMENT_MAX_SIZE)
		));
	$t->wrap('bugattachmentform.html', '', true);
} // end of show_attachment_form($file_id, $error = '')
/////////////////////////////////////////////////////////////////////////////////////////////////////
?>
