<?php
// config.php - Set up configuration options
// ------------------------------------------------------------------------
// Copyright (c) 2001, 2002 The phpBugTracker Group
// Copyright (c) 2004, 2005 David Han Sze Chuen, Denis Guinnepain for Air Liquide Medical Systems (Taema)
// Copyright (c) 2005, 2006, 2015 Denis Guinnepain
 
// ------------------------------------------------------------------------
// This file is part of Diamentis

// Diamentis is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// Diamentis is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with phpBugTracker; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// ------------------------------------------------------------------------

// Database Config
define ('DB_TYPE', '{db_type}');  // using PEAR::DB naming (mysql, pgsql, etc.)
define ('DB_HOST', '{db_host}'); // hostname of database server
define ('DB_DATABASE', '{db_database}'); // database name
define ('DB_USER', '{db_user}'); // username for database connection
define ('DB_PASSWORD', '{db_pass}'); // password for database connection

// Smarty templates location (leave blank if Smarty is in include path)
// If not blank, make sure the trailing slash is present.
define ('SMARTY_PATH', '{smarty_path}');

// Database Table Config
// you can change either the prefix of the table names or each table name individually
define ('TBL_PREFIX', '{tbl_prefix}');	// the prefix for all tables, leave empty to use the old style

define ('TBL_ATTACHMENT',      TBL_PREFIX.'attachment');
define ('TBL_AUTH_GROUP',      TBL_PREFIX.'auth_group');			//TODO must be renamed
define ('TBL_AUTH_PERM',       TBL_PREFIX.'auth_perm');				//TODO must be renamed
define ('TBL_AUTH_USER',       TBL_PREFIX.'auth_user');				//TODO must be renamed
define ('TBL_BUG_CC',          TBL_PREFIX.'contacts');				// renamed from bug_cc
define ('TBL_BUG_DEPENDENCY',  TBL_PREFIX.'bug_dependency');		//TODO must be renamed
define ('TBL_FILE_HISTORY',     TBL_PREFIX.'file_history');			//TODO must be renamed
define ('TBL_BUG_VOTE',        TBL_PREFIX.'bug_vote');				//TODO must be renamed
define ('TBL_COMMENT',         TBL_PREFIX.'comment');
define ('TBL_CONFIGURATION',   TBL_PREFIX.'configuration');
define ('TBL_GROUP_PERM',      TBL_PREFIX.'group_perm');
define ('TBL_PROJECT',         TBL_PREFIX.'project');
define ('TBL_SAVED_QUERY',     TBL_PREFIX.'saved_query');
define ('TBL_USER_GROUP',      TBL_PREFIX.'user_group');
define ('TBL_USER_PREF',       TBL_PREFIX.'user_pref');
define ('TBL_PROJECT_GROUP',   TBL_PREFIX.'project_group');
define ('TBL_PROJECT_PERM',    TBL_PREFIX.'project_perm');

// The new tables for Memento Plus
define ('TBL_ASSIGNATION',     TBL_PREFIX.'assignation');
define ('TBL_FILE_INDEX',      TBL_PREFIX.'file_index');
define ('TBL_FIELD_CONF',      TBL_PREFIX.'field_conf');
define ('TBL_FIELD_TYPE',      TBL_PREFIX.'field_type');
define ('TBL_SELECTBOX_VALUE', TBL_PREFIX.'selectbox_value');
define ('TBL_SELECTBOX_OPTION', TBL_PREFIX.'selectbox_option');
define ('TBL_PROJECT_STATUS',  TBL_PREFIX.'project_status');
define ('TBL_FILE_STATUS',	   TBL_PREFIX.'file_status');

// define some default DB values
define('SELECTBOX_TYPE', 'Select box');
define('SELECT_TWINBOX_TYPE', 'Select Twinbox');
define('INTEGER_TYPE', 'Integer');
define('FLOAT_TYPE', 'Float');
define('STRING_TYPE', 'String');
define('TIMESTAMP_TYPE', 'Timestamp');

define('SELECTBOX_STATUS', 'status_id');

// selectbox options
define('OPTION_CLOSED', 'closed');
define('OPTION_RESERVED', 'reserved');

// timestamp sub types
define('TIMESTAMP_TO_DATE', 'date');
define('TIMESTAMP_TO_HOUR', 'hour');
define('TIMESTAMP_TO_TIME', 'time');

// define('DATE_FORMAT_DETAILED', 'd-m--Y H:i');
// this is used to detect a valid date : it's a french date format : dd/mm/yyyy hh:mm
define('INTERNAL_DATE_FORMAT', "/(\d\d)[-\/](\d\d)(-|--|\/)(\d{4})[ ]*((\d\d|\d)[:h](\d\d))?/i");
/*
	Here is the elements' affectation :
		$month = $date_elements[2];
		$day = $date_elements[1];
		$year = $date_elements[4];
		if (isset($date_elements[5])) {
		$hour = $date_elements[6];
		$minute = $date_elements[7];
*/
define('INTERNAL_DATE_FORMAT_JS', "/([ ]*(\d\d)[-\/](\d\d)(-|--|\/)(\d{4})[ ]*((\d\d|\d)[:h](\d\d))?[ ]*|[ ]*)/i"); // used in queryform-simple.html

// choose debug mode
$verbose = false;

define ('ONEDAY', 86400);
define ('APPLICATION_VERSION', 'V1.7');

require_once ('./inc/auth.php');

?>
