<?php

// draw.php - draw charts on statistics
// ------------------------------------------------------------------------
// Copyright (c) 2005, 2006, 2015 Denis Guinnepain
 
// ------------------------------------------------------------------------
// This file is part of Diamentis

// Diamentis is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// Diamentis is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with phpBugTracker; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// ------------------------------------------------------------------------


require_once ("include.php");

require_once ("Pie.class.php");
require_once "BarPlot.class.php";

function draw_pie($Table,$Title,$column)
{

//	println("draw_pie");
//	printarray($Table);
$graph = new Graph(500, 300);
//	println("draw_pie");
$graph->setBackgroundGradient(
	new LinearGradient(
		new White,
		new VeryLightGray,
		0
	)
);
//	println("draw_pie");
$graph->title->set("$Title");
$graph->shadow->setSize(7);
$graph->shadow->smooth(TRUE);
$graph->shadow->setPosition(SHADOW_LEFT_BOTTOM);

//$graph->title->SetFont(FF_VERA,FS_BOLD);

foreach ($Table as $NbRow=>$Row)
{
//println("Row :");
//printarray($Row);
	foreach ($Row as $k=>$v)
	{
	if ($k==$column)
	{
		$data[]=$v;
	}
	if ($k=="label")
		$leg[]=$v;
	

	}
}

//println("data");
//printarray($data);
//println("leg");
//printarray($leg);


$plot = new Pie($data);
$plot->setCenter(0.32, 0.55);
$plot->setSize(0.7, 0.6);
$plot->set3D(10);


$plot->setLegend($leg);

$plot->legend->setPosition(1.46);
$plot->legend->setBackgroundColor(new VeryLightGray(30));

$graph->add($plot);
$graph->draw();
//print "titi";

}

function draw_bar($Table,$Title,$column)
{

//	println("draw_pie");
	$nbCol=count($Table);
	$h_size=min($nbCol*100,1000);
//	printarray($Table);die;
$graph = new Graph($h_size, 300);
//	println("draw_pie");
$graph->setBackgroundGradient(
	new LinearGradient(
		new White,
		new VeryLightGray,
		0
	)
);
//	println("draw_pie");
$graph->title->set("$Title");
$graph->shadow->setSize(7);
$graph->shadow->smooth(TRUE);
$graph->shadow->setPosition(SHADOW_LEFT_BOTTOM);

//$graph->title->SetFont(FF_VERA,FS_BOLD);

foreach ($Table as $NbRow=>$Row)
{
//println("Row :");
//printarray($Row);
	foreach ($Row as $k=>$v)
	{
	if ($k==$column)
	{
		$data[]=$v;
	}
	if ($k=="label")
	{
		$leg[]=$v;
	}

	}
}

//println("data");
//printarray($data);
//println("leg");
//printarray($leg);


$plot = new BarPlot($data);
//$plot->setCenter(0.32, 0.55);
//$plot->setSize(0.7, 0.6);
//$plot->set3D(10);


//$plot->setLegend($leg);

$plot->legend->setPosition(1.46);
$plot->legend->setBackgroundColor(new VeryLightGray(30));

// Reduce padding around the plot
$plot->setPadding(NULL, NULL, NULL, 20);

// Reduce plot size and move it to the bottom of the graph
$plot->setSize(1, 0.96);
$plot->setCenter(0.5, 0.52);

// Set a background color to the plot
$plot->grid->setBackgroundColor(new White);
// Set a dashed grid
$plot->grid->setType(LINE_DASHED);


//$plot->label->set($leg);
//$plot->label->move(0, -10);
//$plot->label->setColor(new DarkBlue);

// Set a shadow to the bars
$plot->barShadow->setSize(2);

// Bar size is at 40%
$plot->setBarSize(0.4);

// Change the color of the bars
$plot->setBarColor(
	new Orange(15)
);

// Add the plot to the graph
//$graph->add($plot);

// Draw the graph
//$graph->draw();


$graph->add($plot);
$graph->draw();
//print "titi";

}




function draw_pieJPGraph($Table,$Title,$column)
{

//println("draw_pie");
//printarray($Table);
$graph = new PieGraph(500,300,"auto");
$graph->SetShadow();
$graph->title->Set("DiaMeter : $Title");
$graph->title->SetFont(FF_VERA,FS_BOLD);

foreach ($Table as $NbRow=>$Row)
{
//println("Row :");
//printarray($Row);
	foreach ($Row as $k=>$v)
	{
		if ($k==$column)
		{
			$data[]=$v;
		}
		if ($k=="label")
		{
			$leg[]=$v;
		}

	}
}

//println("data");
//printarray($data);
//println("leg");
//printarray($leg);

$p1 = new PiePlot3D($data);
$p1->SetSize(.3);
$p1->SetCenter(0.33);
$p1->SetStartAngle(20);
$p1->SetAngle(45);

$p1->SetLegends($leg);

$p1->value->SetFont(FF_FONT1,FS_BOLD);
$p1->value->SetColor("darkred");
$p1->SetLabelType(PIE_VALUE_PER);

$a = array_search(max($data),$data); //Find the position of  maixum value.
$p1->ExplodeSlice($a);

$graph->Add($p1);
$graph->Stroke();
}

function pie_test()
{
	$toto['data']=1;
	$toto['label']="test1";
	draw_pie(array($toto,$toto));
}

if (isset($_GET['op'])) 
{
	switch ($_GET['op']) 
	{
		case 'stat' :
			if ($HTTP_SESSION_VARS['queryinfo']['ChartSelect']=="isBar")
			{
				draw_bar($HTTP_SESSION_VARS['queryinfo']['res'],$HTTP_SESSION_VARS['queryinfo']['title_stat'],"data");
			}
			else
			{
				draw_pie($HTTP_SESSION_VARS['queryinfo']['res'],$HTTP_SESSION_VARS['queryinfo']['title_stat'],"data");
			}
			break;
		case 'weight' :
			if ($HTTP_SESSION_VARS['queryinfo']['ChartSelect']=="isBar")
			{
				draw_bar($HTTP_SESSION_VARS['queryinfo']['res'],$HTTP_SESSION_VARS['queryinfo']['title_weight'],"w_data");
			}
			else
			{
				draw_pie($HTTP_SESSION_VARS['queryinfo']['res'],$HTTP_SESSION_VARS['queryinfo']['title_weight'],"w_data");
			}
			break;
		default :
			break;
	}
}
//print "totto";
//pie_test();
//print "totto";
?>