<?php

// auth.php - Authentication and permission objects
// ------------------------------------------------------------------------
// Copyright (c) 2001, 2002 The phpBugTracker Group
// ------------------------------------------------------------------------
// This file is part of phpBugTracker
//
// phpBugTracker is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// phpBugTracker is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with phpBugTracker; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// ------------------------------------------------------------------------
// Based on and/or directly from PHPlib, which is 
// Copyright (c) 1998-2000 NetUSE AG -- Boris Erdmann, Kristian Koehntopp

class uauth {
	var $lifetime = 0; // In minutes -- 0 for no expiration until browser closed
	var $classname = 'uauth';
	
	/**
		FM1155 : david.han-sze-chuen@airliquide.com 8/7/2004
		This function sets the value of 'exp' in the session, 
		depending on the user session lifetime defined in this class. 
	*/
	function setExpirationTime() {
		global $HTTP_SESSION_VARS;
		$HTTP_SESSION_VARS['exp'] = time() + (60 * $this->lifetime);		
	}
	
	// FM1155 : david.han-sze-chuen@airliquide.com 8/7/2004
	function uauth() {
		global $HTTP_SESSION_VARS, $group_ids, $uname, $db_fields, $group, $perms,
			$uid, $exp;
		
		if (!isset($HTTP_SESSION_VARS['group_ids'])) {
			if (phpversion() <= '4.0.6') {			
				$group_ids = array(0);
				$uname = '';
				$db_fields = array();
				$group = array();
				$perms = array();
				$uid = 0;
				$exp = 0;
				session_register(array('group_ids', 'uname', 'db_fields', 'group', 
					'perms', 'uid', 'exp'));
			}
			$HTTP_SESSION_VARS['group_ids'] = array(0);
		}
		
		if ($this->is_authenticated()) {
			/*
			if ($HTTP_SESSION_VARS['uid']) {
				$HTTP_SESSION_VARS['exp'] = time() + (60 * $this->lifetime);
				
				$HTTP_SESSION_VARS['time'] = time();
			}
			*/
			$this->setExpirationTime();
		}
	//	else session_unregister('uid');		
	}
	// end FM1155 : david.han-sze-chuen@airliquide.com 8/7/2004

	// FM1155 : david.han-sze-chuen@airliquide.com 8/7/2004
	function is_authenticated() {
		global $HTTP_SESSION_VARS;
		
		//DEBUG		
		
		/*echo "issset(uid) = " . (isset($HTTP_SESSION_VARS['uid'])?'true':'false') . "<br>";
		echo "uid? = " . ($HTTP_SESSION_VARS['uid']?'true':'false') . "<br>";
		echo "lifetime = $this->lifetime <br>";
		echo "exp = {$HTTP_SESSION_VARS['exp']} <br>";
		echo "time() = " . time() . "<br>";
		echo "time() < exp = " . ((time() < $HTTP_SESSION_VARS['exp'])?'true':'false') . "<br>";		
		*/
		
		if (isset($HTTP_SESSION_VARS['uid']) && $HTTP_SESSION_VARS['uid'] && 
			(($this->lifetime <= 0) || (time() < $HTTP_SESSION_VARS['exp']))) {			
			//DEBUG
			//echo "<b>is_authenticated() = true </b><br>";			
			return $HTTP_SESSION_VARS['uid'];
		} else {
			//DEBUG
			//echo "<b>is_authenticated() = false </b><br>";
			return false;
		}
	}
	// end FM1155 : david.han-sze-chuen@airliquide.com 8/7/2004
	
// FM 171 : 23/02/04 add manageProject rights
	function auth_validatelogin() {
    global $_pv, $db, $select, $emailpass, $emailsuccess, $STRING, 
			$HTTP_SESSION_VARS, $uid;

		extract($_pv);
    if (!$username) return 0;
    $HTTP_SESSION_VARS['uname'] = $username;
    if (ENCRYPT_PASS) {
      $password = md5($password);
    }
    $u = $db->getRow("select * from ".TBL_AUTH_USER." where login = '$username' and password = '$password' and active > 0");
    if (!$u or DB::isError($u)) {
      return 0;
    } else {
			$HTTP_SESSION_VARS['db_fields'] = @unserialize($u['bug_list_fields']);
			$HTTP_SESSION_VARS['access_project'] = @unserialize($u['access_project']);
			$HTTP_SESSION_VARS['pageSize'] = $u['page_size'];

      // Grab group assignments and permissions based on groups
			$rs = $db->query("select u.group_id, group_name from ".TBL_USER_GROUP.
				" u, ".TBL_AUTH_GROUP." a where user_id = {$u['user_id']} ".
				'and u.group_id = a.group_id');
			while (list($groupid, $groupname) = $rs->fetchRow(DB_FETCHMODE_ORDERED)) {
				$HTTP_SESSION_VARS['group_ids'][] = $groupid;
				$HTTP_SESSION_VARS['group'][$groupname] = true;
			}
			$perms = $db->getCol("select perm_name from ".TBL_AUTH_PERM." ap, ".
				TBL_GROUP_PERM." gp where group_id in (".
				delimit_list(',', $HTTP_SESSION_VARS['group_ids']).") and gp.perm_id = ap.perm_id");
			foreach ($perms as $perm) {				
        $HTTP_SESSION_VARS['perms'][$perm] = true;
	
      }

			// FM 171 : Grab project_admin assignments based on project
			$rs = $db->query("select pp.project_id, ap.perm_name from ".TBL_AUTH_PERM.
				" ap, ".TBL_PROJECT_PERM. " pp  where pp.user_id = {$u['user_id']} and ap.perm_id=pp.perm_id");
			while (list($project_id, $permname) = $rs->fetchRow(DB_FETCHMODE_ORDERED)) {
				if ($permname=='Admin')
				{
					$HTTP_SESSION_VARS['perms']['Manage'][$project_id][$permname]=true;
					$HTTP_SESSION_VARS['perms']['AdminProject'] = true;
				} elseif ($permname=='Editbug')
				{
					$HTTP_SESSION_VARS['perms']['Edit'][$project_id][$permname]=true;
					$HTTP_SESSION_VARS['perms']['Editbug'] = true;
				}
      }
			// End Of FM 171

			$HTTP_SESSION_VARS['uid'] = $u['user_id'];
			$this->setExpirationTime(); // if the user is authenticated, his session expiration time has to be set 
      return $u['user_id'];
    }
  }
	
	function unauth() {
		global $HTTP_SESSION_VARS;
		
    $HTTP_SESSION_VARS['uid'] = 0;
		$HTTP_SESSION_VARS['perms'] = array();
		$HTTP_SESSION_VARS['exp']   = 0;
    $HTTP_SESSION_VARS['group'] = array();
    $HTTP_SESSION_VARS['group_ids'] = array(0);
    $HTTP_SESSION_VARS['db_fields'] = array();
  }
}

class uperm {
  var $classname = 'uperm';
  var $permissions = array ();

  function check($p) {
    global $HTTP_SESSION_VARS;

    if (!$this->have_perm($p)) {    
      if (!isset($HTTP_SESSION_VARS['perms']) ) {
        $HTTP_SESSION_VARS['perms'] = '';
      }
      $this->perm_invalid($HTTP_SESSION_VARS['perms'], $p);
      exit();
    }
  }

  function check_auth($auth_var, $reqs) {
    global $HTTP_SESSION_VARS;

    // Administrators always pass
    if (@isset($HTTP_SESSION_VARS[$auth_var]['Admin'])) {
      return true;
    }

    if (is_array($reqs)) {
      foreach ($reqs as $req) {
        if (!@isset($HTTP_SESSION_VARS[$auth_var][$req])) {
          return false;
        }
      }
    } else {
      if (!@isset($HTTP_SESSION_VARS[$auth_var][$reqs])) {
        return false;
      }
    }

    // Didn't fail on any requirements?  Then the user passes the check
    return true;
  }

// FM 171 : Grab project_admin assignments based on project
  function have_project_perm($project_id,$perm) {
    global $HTTP_SESSION_VARS,$u,$db;
    // Administrators always pass
    if (@isset($HTTP_SESSION_VARS['perms']['Admin'])) {
      return true;
    }
	if (!($perm_id=$db->getOne(" SELECT perm_id FROM " . TBL_AUTH_PERM . " WHERE perm_name='$perm'")))
	{
		return false;
	}
	$project_option=$db->getRow("SELECT  share_view_all, share_edit_log, share_struct,authorize_request,share_new FROM " . TBL_PROJECT . " WHERE project_id=$project_id");
//	printarray($project_option);
	switch ($perm)
	{
		case 'New' :
			if ($project_option['share_new'])
			{
				return true;
			}
			else
			{	
				if ($db->getOne("SELECT pp.user_id FROM " . TBL_PROJECT_PERM . " pp, " . TBL_AUTH_PERM . " ap WHERE pp.user_id=$u AND pp.project_id=$project_id AND pp.perm_id<=ap.perm_id AND ap.perm_name='View'"))
				{
					return true;
				}
			}
			break;
		case 'ViewStruct' :
			return $project_option['share_struct'];
			break;
		case 'Request' :
			if ($project_option['share_view_all']||$project_option['share_edit_log'])
			{
				return true;
			}
			else
			{
				return $db->getOne("SELECT user_id FROM " . TBL_PROJECT_PERM . " WHERE user_id=$u AND project_id=$project_id AND perm_id<=$perm_id");
			}
			break;
		case 'Invite' :
			if ($project_option['authorize_request']||$project_option['share_view_all']||$project_option['share_edit_log'])
			{
				return true;
			}
			else
			{
				if ($db->getOne("SELECT pp.user_id FROM " . TBL_PROJECT_PERM . " pp, " . TBL_AUTH_PERM . " ap WHERE pp.user_id=$u AND pp.project_id=$project_id"))
				{
					return true;
				}
			}
			break;
		case 'View' :
			if ($project_option['share_view_all'])
			{
				return true;
			}
			else
			{
				return $db->getOne("SELECT user_id FROM " . TBL_PROJECT_PERM . " WHERE user_id=$u AND project_id=$project_id AND perm_id<=$perm_id");
			}
			break;
		case 'Editbug' :
			if ($project_option['share_edit_log'])
			{
				return true;
			}
			else
			{
				return $db->getOne("SELECT user_id FROM " . TBL_PROJECT_PERM . " WHERE user_id=$u AND project_id=$project_id AND perm_id<=$perm_id");
			}
			break;
		case 'Admin' :
			return $db->getOne("SELECT user_id FROM " . TBL_PROJECT_PERM . " WHERE user_id=$u AND project_id=$project_id AND perm_id<=$perm_id");
			break;
		default:
			return false;
		break;
	}
	return false;
/*      if (!@isset($HTTP_SESSION_VARS['perms']['Manage']["$project_id"]["$perm"]) && $perm=="Admin")  
      {
        return false;
      }

      if (!@isset($HTTP_SESSION_VARS['perms']['Edit']["$project_id"]["$perm"]) && $perm=="Editbug")  
      {
        return false;
      }

    // Didn't fail on any requirements?  Then the user passes the check
    return true; */
  }
// End of FM 171
  function verify_perm($project_id,$perm)
  {
  	global $STRING;
     if (!($this->have_project_perm($project_id,$perm)))
     {
     	death("ERROR",$STRING['bad_permission'] . " ($project_id, $perm) ");
     }
  }

  function verify_perm_file($file_id,$perm)
  {
  	global $db;
  	if ($project_id=$db->getOne("SELECT project_id FROM " . TBL_FILE_INDEX . " WHERE file_id=$file_id "))
  	{
  		return $this->verify_perm($project_id,$perm);
  	}
  	else
  	{
  		return false;
  	}
  }
  
  function in_group($req_groups) {
    return $this->check_auth('group', $req_groups);
  }


  function have_perm($req_perms) {
    return $this->check_auth('perms', $req_perms);
  }


  function perm_invalid($actual_perms, $required_perms) {
    global $t;
		
    $t->wrap('badperm.html');
  }

	function check_group($group) {
		global $t;

		if (!$this->check_auth('group', $group)) {		
			$t->assign('group', $group);
			$t->wrap('badgroup.html');
			exit();
		}
	}
}

?>
