<?php
/*
	From the project : SYIBIB - Systme d'Information Bibtex
	Now for the project : Memento Plus
	Developped for TAEMA, Air Liquide Sant
	Creation date : January 2004
	@author david.han-sze-chuen
	School : ISTY
	
	filename : func_html.inc.php
	Description : html output functions
*/
// //////////////////////////////////////////////////////////////////////////////
/*
About the $cmdtype argument :
Let's explain this with some code ;-)
switch($cmdtype) {
	default: 
	case 1 : echo "print the code directly to the standard output";
		break;
	case 11 : echo "return the html code. ie: return $output;";
		break;
	case -1 : echo "print the html closing tag. ie: </table>";
		break;
	case -11 : echo "return the html closing tag. ie: return $output = </table>;";
		break;
}
*/
// print an error message and ends the execution
function death($error_name, $context) {
	global $t; 
	// print("<B><I><FONT color=red>$error_name : $context </FONT></I></B><BR>");
	// previouspage_button($cmdtype = 1);
	$t->assign('isError', true);
	$t->assign('text', "<B><I><FONT color=red>$error_name : $context </FONT></I></B><BR>"); 
	// do we have to put the admin directory ?
	$cwd = $_SERVER['PHP_SELF']; 
	// println("cwd = $cwd");
	$parts = explode('/', $cwd); 
	// printarray($parts);
	$dir = '';
	if ((count($parts) > 2) && ($parts[count($parts) - 2] == 'admin'))
		$dir = 'admin/'; 
	// println("dir $dir");
	$t->wrap($dir . 'error.html');
	die();
} // end of death($error_name, $context)
// //////////////////////////////////////////////////////////////////////////////
// print a <HR>
function hr() {
	echo "<HR>\n";
} // end of hr()
// //////////////////////////////////////////////////////////////////////////////
// print a <BR>
function br() {
	echo "<br>\n";
} // end of br()
// //////////////////////////////////////////////////////////////////////////////
// print <BR> n times
function brn($int, $cmdtype = 1) {
	$int = abs($int);
	$sentence = "";
	for ($i = 0; $i < $int; $i ++) {
		$sentence = $sentence . "<br>\n";
	} 
	switch ($cmdtype) {
		case 1 :
			echo $sentence;
			break;
		case 11 :
			return $sentence;
			break;
		default :
			death("ERR_InvalidOption", "Bad command type, brn(\"$int\", \"$cmdtype\").");
	} 
} // end of brn($int, $cmdtype=1)
// //////////////////////////////////////////////////////////////////////////////
// create a form, does not filter incoming data
function form($name, $destination, $cmdtype = 1, $option = '') {
	// $n = addslashes($name);
	$n = &$name;
	$d = &$destination; 
	// $d = addslashes($destination);
	$text = "<FORM NAME=\"$n\" ACTION=\"$d\" METHOD = POST $option >\n";
	switch ($cmdtype) {
		case 11 :
			return $text;
			break;
		case 1 :
			echo $text;
			break;
		case -1 :
			echo "</FORM>\n";
			break;
		case -11 :
			return "</FORM>\n";
			break;
		default :
			death("ERR_InvalidOption", "Bad command type, form(\"$name\", \"$destination\", $cmdtype, \"$option\")");
	} 
} // end of form($name, $destination, $cmdtype = 1, $option = '')
// //////////////////////////////////////////////////////////////////////////////
// print a form closing tag
function closeform($format = 1) {
	switch ($format) {
		case 1 :
			echo "</FORM>\n";
		case 11 :
			return "</FORM>\n";
	} 
} // end of closeform($format = 1)
// //////////////////////////////////////////////////////////////////////////////
// print a html textarea, incoming data is not filtered
function textarea($name, $width, $height, $value, $cmdtype = 1, $option = '') {
	$n = &$name; // addslashes($name);
	$v = &$value; // addslashes($value);
	$c = &$width; // addslashes($col);
	$r = &$height; // addslashes($row);
	$text = "<TEXTAREA NAME=\"$n\" COLS=\"$c\" ROWS=\"$r\" $option >$v</TEXTAREA>\n";

	switch ($cmdtype) {
		case 11 :
			return $text;
			break;
		case 1 :
			echo $text;
			break;
		default :
			death("ERR_InvalidOption", "Bad command type, textarea(\"$name\", \"$col\", \"$row\", \"$value\", \"$cmdtype\", \"$option\")");
	} 
} // end of textarea($name, $col, $row, $value, $cmdtype=1, $option='')
// //////////////////////////////////////////////////////////////////////////////
// just prints a line with <br>
function println($string) {
	echo $string . "<br>";
} 
// //////////////////////////////////////////////////////////////////////////////
// function which surround a string with a html tag, with possible option
function htmlsurround($input_string, $tag_name = "p", $tag_option = "") {
	return "<$tag_name" . (empty($tag_option)?'':" $tag_option") . ">$input_string</$tag_name>\n";
} 
// //////////////////////////////////////////////////////////////////////////////
// function which makes a html string bold
function htmlsurround_bold($input_string, $tag_option = "") {
	return htmlsurround($input_string, "b", $tag_option);
} 
// //////////////////////////////////////////////////////////////////////////////
// function which returns a HTML string and keeps the text indentation
function htmltruespace($input_string) {
	return str_replace("  ", "&nbsp;&nbsp;", $input_string);
} 
// //////////////////////////////////////////////////////////////////////////////
// function that prints all the elements of an array, with HTML tables
$_printarray = 0; // external counter
function printarray($a, $prec = '', $p = 0) {
	global $_printarray;

	if ($p >= 0) {
		// table("printarray$p", '', '', '', 1, 'BORDER=0 cellspacing=1 ');
		echo "<table border=0 cellspacing=1>\n";
		$_printarray = 0;
	} 

	if (is_array($a) && count($a)) {
		foreach ($a as $t => $v) {
			printarray($v, $prec . "<TD valign=\"top\">['$t']</TD>\n", -1);
		} 
	} else {
		if (is_object($a)) {
			switch (get_class($a)) {
				case 'mpsubproperty' :
					$a = $a->toString($toPrint = false, $inHTML = true);
					break;
			} 
		} elseif (is_array($a)) { // it must be an empty array
			$a = "Empty $a";
		} elseif (is_bool($a)) {
			$a = ($a === true)? 'True':'False';
		} 

		$a = @nl2br($a);

		echo "<TR> <TD style=\"text-align: right; \" valign=\"top\" nowrap=2  >$_printarray : </TD>
				$prec <TD valign=\"top\">=</TD><TD valign=\"top\"> $a </TD>
			 </TR>\n";
		$_printarray++;
	} 

	if ($p >= 0)
		echo "</table>\n";
} // fin de printarray($a, $prec = '', $p = 0) 
// //////////////////////////////////////////////////////////////////////////////
// create a submit button
function submitbutton($value, $cmdtype = 1, $option = '') {
	$v = &$value; // addslashes($value);
	switch ($cmdtype) {
		case 11 :
			return "<INPUT TYPE=SUBMIT $option VALUE=\"$v\">\n";
			break;
		case 1 :
			echo "<INPUT TYPE=SUBMIT $option VALUE=\"$v\">";
			break;
		default :
			death("ERR_InvalidOption", "Bad command type, submitbutton(\"$value\", \"$cmdtype\", \"$option\")");
	} 
} // end of submitbutton($value, $cmdtype = 1, $option = '')
// //////////////////////////////////////////////////////////////////////////////
// create a reset button
function resetbutton($value, $cmdtype = 1, $option = '') {
	$v = &$value; // addslashes($value);
	switch ($cmdtype) {
		case 11 :
			return "<INPUT TYPE=RESET $option VALUE=\"$v\">\n";
			break;
		case 1 :
			echo "<INPUT TYPE=RESET $option VALUE=\"$v\">";
			break;
		default :
			death("ERR_InvalidOption", "Bad command type, resetbutton($value, $cmdtype, $option)");
	} 
} // fin de resetbutton($value, $cmdtype=1, $option='')
// //////////////////////////////////////////////////////////////////////////////
// insert n*spaces in HTML
function nspace($int, $cmdtype = 1) {
	$int = abs($int);
	$sentence = "";
	for($i = 0; $i < $int; $i++) {
		$sentence = $sentence . "&nbsp;";
	} 

	switch ($cmdtype) {
		case 1 : echo $sentence;
			break;
		case 11 : return $sentence;
			break;
		default :
			death("ERR_InvalidOption", "Bad command type, nspace($int, $cmdtype)");
	} 
} // end of nspace($int, $cmdtype=1)
// //////////////////////////////////////////////////////////////////////////////
/**
 build a listbox
 @param string $name name of the listbox
 @param array $value The list of values : $value[<listbox_value>] = <listbox_text>
 @param integer $cmdtype Type of output : 1 = echo the result html code, 11 = return the html code
 @param boolean $multiple if true, allow to select multiple rows
 @param mixed $selected it a <listbox_value> == $selected, this listbox value will be pre-selected
 @param mixed $option HTML code to add to this selectbox
 @param array $titles Array of text titles visible on mouse hovering. $titles[<listbox_value>] = <listbox_title>
 @return mixed Depend on $cmdtype.
*/ 
function listbox($name, $value, $cmdtype = 1, $multiple = false, $selected = null, $option = '', $titles = null) {
	global $STRING;
	// $v = addslashes($value);
	$n = addslashes($name);

	if ($multiple) {
		$mult = "MULTIPLE";
		$n .= "[]";
	} 

	$text = "<SELECT $mult $option NAME=\"$n\">\n";

	if (is_array($value)) {
		if (is_array($titles)) {
			reset($titles);
		}
		foreach($value as $t => $val) {
			if(is_array($titles)) {
				$title = current($titles);
				next($titles);
			} else {
				$title = null;
			}
			
			$isSelect = '';
			if ($selected != null) {
				if (($selected == $t) || (is_array($selected) && in_array($t, $selected))) {
					$isSelect = 'SELECTED';
				} 
			} 

			$text .= "<OPTION $isSelect title=\"$title\" value=\"$t\">$val</OPTION>\n";
		} 
	} else {
		$isSelect = '';
		if ($selected != false) {
			$isSelect = 'SELECTED';
		} 
		$text .= "<OPTION $isSelect >$value</OPTION>\n";
	} 

	$text .= "</SELECT>\n";
	
	if ($multiple)
	{
		$text.=" <br><I>(".htmlspecialchars($STRING['multiple_select']) . ")<i>";
	}

	switch ($cmdtype) {
		case 11 :
			return $text;
			break;
		case 1 :
			echo $text;
			break;
		default :
			death("ERR_InvalidOption", "Bad command type, listbox($name, $value, $cmdtype, $option)");
	} 
} // end of listbox($name, $value, $cmdtype=1, $option='')
// //////////////////////////////////////////////////////////////////////////////
// build a text input line
function text($name, $value, $cmdtype = 1, $option = '') {
	// $n = addslashes($name); // this type of filtering isn't appropriated
	// $v = addslashes($value);
	$n = &$name;
	$v = &$value;

	$text = "<INPUT TYPE=\"TEXT\" $option NAME=\"$n\" VALUE=\"$v\">\n";

	switch ($cmdtype) {
		case 11 :
			return $text;
			break;
		case 1 :
			echo $text;
			break;
		default :
			death("ERR_InvalidOption", "Bad command type, text($name, $value, $cmdtype, $option)");
	} 
} // end of text($name, $value, $cmdtype=1, $option = '')
// //////////////////////////////////////////////////////////////////////////////
// build a textlist
function textlist($values, $cmdtype = 1, $option = '') {
	$text = "<UL COMPACT $option >\n";

	if (is_array($values)) {
		foreach($values as $t => $val) {
			$text .= "<LI>$val\n";
		} 
	} else $text .= "<LI>$values\n";

	$text .= "</UL>\n";

	switch ($cmdtype) {
		case 11 :
			return $text;
			break;
		case 1 :
			echo $text;
			break;
		default :
			death("ERR_InvalidOption", "Bad command type, textlist($values, $cmdtype = 1, $option)");
	} 
} // end of textlist($values, $cmdtype = 1, $option = '')
// //////////////////////////////////////////////////////////////////////////////
// create a simple radio or checkbox
function xbox($name, $value, $type, $checked = false, $cmdtype = 1, $option = '') {
	$v = addslashes($value);
	$n = addslashes($name);

	$checked = ($checked == true)? "CHECKED" : '';

	switch (strtolower($type)) {
		case 'radio':
			$type = 'RADIO';
			break;
		default:
		case 'checkbox' :
			$type = 'CHECKBOX';
			break;
	} 

	switch ($cmdtype) {
		case 11 :
			return "<INPUT TYPE=\"$type\" VALUE=\"$v\" $checked $option NAME=\"$n\">\n";
			break;

		case 1 :
			echo "<INPUT TYPE=\"$type\" VALUE=\"$v\" $checked $option NAME=\"$n\">";
			break;
		default :
			death("ERR_InvalidOption", "Bad command type, xbox($name, $value, $checked, $cmdtype, $option)");
	} 
} // end of xbox($name, $value, $type, $checked = false, $cmdtype = 1, $option = '')
// //////////////////////////////////////////////////////////////////////////////
function checkbox($name, $value, $checked = false, $cmdtype = 1, $option = '') {
	return xbox($name, $value, $type = 'checkbox', $checked, $cmdtype, $option);
} // end of checkbox($name, $value, $checked = false, $cmdtype = 1, $option = '')
// //////////////////////////////////////////////////////////////////////////////
function radiobox($name, $value, $checked = false, $cmdtype = 1, $option = '') {
	return xbox($name, $value, $type = 'radio', $checked, $cmdtype, $option);
} // end of radiobox($name, $value, $checked = false, $cmdtype = 1, $option = '')
// //////////////////////////////////////////////////////////////////////////////
function YesNoQuestion($name, $msg, $yes = false, $cmdtype = 1, $option = '') {
	global $STRING;
	$str = '';
	$str .= $msg . " : <br>";
	$str .= radiobox($name, $STRING['YES'], $yes == true, $cmdtype, $option) . " {$STRING['YES']}";
	$str .= '&nbsp;&nbsp;&nbsp;' . radiobox($name, $STRING['NO'], $yes != true, $cmdtype, $option) . " {$STRING['NO']}";

	switch ($cmdtype) {
		case 1 :
			echo $str;
			break;
		case 11 :
			return $str;
		default :
			death("ERR_InvalidOption", htmlspecialchars("Bad command type, YesNoQuestion($name, $msg, $yes, $cmdtype, $option)"));
	} 
} // end of YesNoQuestion($name, $msg, $yes = false, $cmdtype = 1, $option = '')
// //////////////////////////////////////////////////////////////////////////////
// make a 'previous' button
function previouspage_button($cmdtype = 1) {
	global $STRING;
	$text = "<INPUT TYPE=\"Button\" Value=\"$STRING[PreviousPage]\" OnClick=\"javascript:history.go(-1)\">\n";

	switch ($cmdtype) {
		case 1 : echo $text;
		case 11 : return $text;
		default :
			death("ERR_InvalidOption", "Bad command type, previouspage_button($cmdtype)");
	} 
} // end of previouspage_button($cmdtype = 1)
// //////////////////////////////////////////////////////////////////////////////
// make a 'next' button
function nextpage_button($cmdtype = 1) {
	global $STRING;
	$cmdtype = "<INPUT TYPE=\"Button\" Value=\"$STRING[NextPage]\" OnClick=\"javascript:history.go(1)\">\n";

	switch ($cmdtype) {
		case 1 : echo $text;
		case 11 : return $text;
		default :
			death("ERR_InvalidOption", "Bad command type, nextpage_button($cmdtype)");
	} 
} // end of nextpage_button($cmdtype = 1)
// //////////////////////////////////////////////////////////////////////////////
// create a hidden value
function hiddenvalue($name, $value, $cmdtype = 1, $option = '') {
	$v = addslashes($value);
	$n = addslashes($name);
	$text = "<INPUT TYPE=HIDDEN NAME=\"$n\" $option VALUE=\"$v\">\n";
	switch ($cmdtype) {
		case 1 :
			echo $text;
		case 11 :
			return $text;
		default :
			death("ERR_InvalidOption", "Bad command type, hiddenbutton($name, $value, $cmdtype, $option)");
	} 
} // end of hiddenbutton($name, $value, $cmdtype=1, $option='')
// //////////////////////////////////////////////////////////////////////////////
// fonction de redirection de page web
function redirection($url) {
	if (headers_sent()) {
		print('<meta http-equiv="refresh" content="0;URL=' . $url . '">');
	} else {
		header("Location: $url\n");
	} 
} // end of redirection($url)
// //////////////////////////////////////////////////////////////////////////////
// delete a cookie, or a cookie array
function delcookie($cookie_name, $suiv = null, $all = null) {
	if ($suiv == null) {
		if (!isset($_COOKIE[$cookie_name])) {
			return false;
		} 
		if (is_array($_COOKIE[$cookie_name])) {
			foreach($_COOKIE[$cookie_name] as $t => $v) {
				delcookie($_COOKIE[$cookie_name], $t, $cookie_name . '[' . $t . ']');
			} 
		} else $all = $cookie_name;
	} 

	if ($suiv != null) {
		$temp = $cookie_name[$suiv];
		if (is_array($temp)) {
			foreach($temp as $t => $v) {
				delcookie($temp, $t, $all . '[' . $t . ']');
			} 
		} 
	} 
	/*
	openscript();
	echo "alert('effacement de $all')";
	closescript();
	*/
	setcookie($all, '');
} // end of delcookie($cookie_name, $suiv = null, $all = null)
// //////////////////////////////////////////////////////////////////////////////
?>