<?php

/**
 * Project : Memento Plus
 * Developped for TAEMA, Air Liquide Sant
 * 
 * @since : August 2004
 * @author david.han-sze-chuen
filename : func_transfer_M_to_MPlus.inc.php
Description : Assume the transfer of data from Memento to Memento Plus 
 */

include_once("include.php");
include_once("inc/func_html.inc.php");

println("<h3>Transfer initialisation :</h3>");

/*
* Note : the sql queries employed here are designed for MySQL.
*  
* 
*/

$sql_insertselect = "insert into ".TBL_SELECTBOX_VALUE."(sv_id, field_conf_id, sv_value, sv_order, sv_description) ";
$sql_set_selectbox_table_autoincrement = "ALTER TABLE `".TBL_SELECTBOX_VALUE."` CHANGE `sv_id` `sv_id` INT( 10 ) UNSIGNED NOT NULL AUTO_INCREMENT";
$sql_unset_selectbox_table_autoincrement = "ALTER TABLE `".TBL_SELECTBOX_VALUE."` CHANGE `sv_id` `sv_id` INT( 10 ) UNSIGNED NOT NULL";

$sql_transfer = array();
$sql_transfer['severity'] = "select null, %s, severity_name, sort_order, severity_desc from mplus_severity";

/*
* Here's what defines the priority.
* It was defined in functions.php before.
* $select['priority'] = array(
*   1 => '1 - Low',
*   2 => '2',
*   3 => '3 - Medium',
*   4 => '4',
*   5 => '5 - High'
*   );
*/
$sql_transfer['assignation'] = "INSERT INTO ". TBL_ASSIGNATION ."(user_id, file_id, assigned_date) ".
							  "SELECT assigned_to, bug_id, '0' FROM ". TBL_BUG .";";
							  
$sql_transfer['file_index'] = "INSERT INTO ". TBL_FILE_INDEX ."(file_id, project_id) ".
							  "SELECT bug_id, project_id FROM ". TBL_BUG .";";
							  
$sql_transfer['priority'] = "
	INSERT INTO `".TBL_SELECTBOX_VALUE."` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
	VALUES ('', '6', '1 - Low', '0', '');
	INSERT INTO `".TBL_SELECTBOX_VALUE."` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
	VALUES ('', '6', '2', '0', '');
	INSERT INTO `".TBL_SELECTBOX_VALUE."` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
	VALUES ('', '6', '3 - Medium', '0', '');
	INSERT INTO `".TBL_SELECTBOX_VALUE."` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
	VALUES ('', '6', '4', '0', '');
	INSERT INTO `".TBL_SELECTBOX_VALUE."` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
	VALUES ('', '6', '5 - High', '0', '');
";

println("Nothing done yet.");

println("<h3>Transfer finished :</h3>");



//////////////////////////////////////////////////////////////////////////////////////////
$selectbox_dump = "
		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (1, '7', 'Status Open', '0', '');
		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (2, '7', 'Status To assign', '0', '');
		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (3, '7', 'Status Closed', '0', '');

		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (4, '5', 'Severity 1', '0', '');
		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (5, '5', 'Severity 2', '0', '');
		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (6, '5', 'Severity 3', '0', '');

		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (7, '6', 'Priority 1', '0', '');
		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (8, '6', 'Priority 2', '0', '');
		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (9, '6', 'Priority 3', '0', '');

		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (13, '8', 'Resolution 1', '0', '');
		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (14, '8', 'Resolution 2', '0', '');
		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (15, '8', 'Resolution 3', '0', '');
		
		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (16, '9', 'Database 1', '0', '');
		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (17, '9', 'Database 2', '0', '');
		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (18, '9', 'Database 3', '0', '');

		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (19, '10', 'Site 1', '0', '');
		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (20, '10', 'Site 2', '0', '');
		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (21, '10', 'Site 3', '0', '');

		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (22, '13', 'Version 1', '0', '');
		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (23, '13', 'Version 2', '0', '');
		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (24, '13', 'Version 3', '0', '');

		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (25, '16', 'Component 1', '0', '');
		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (26, '16', 'Component 2', '0', '');
		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (27, '16', 'Component 3', '0', '');

		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (28, '17', 'OS 1', '0', '');
		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (29, '17', 'OS 2', '0', '');
		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (30, '17', 'OS 3', '0', '');

		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (31, '14', 'closed_in_version 1', '0', '');
		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (32, '14', 'closed_in_version 2', '0', '');
		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (33, '14', 'closed_in_version 3', '0', '');

		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (34, '15', 'to_be_closed_in_version 1', '0', '');
		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (35, '15', 'to_be_closed_in_version 2', '0', '');
		INSERT INTO `mplus_selectbox_value` ( `sv_id` , `field_conf_id` , `sv_value` , `sv_order` , `sv_description` )
		VALUES (36, '15', 'to_be_closed_in_version 3', '0', '');
		";

$file_dump = "INSERT INTO `mplus_file` ( `bug_id` , `title` , `description` , `url` , `severity_id` , `priority` , `status_id` , `resolution_id` , `database_id` , `site_id` , `assigned_to` , `created_by` , `created_date` , `last_modified_by` , `last_modified_date` , `project_id` , `version_id` , `component_id` , `os_id` , `browser_string` , `close_date` , `closed_in_version_id` , `to_be_closed_in_version_id` )
VALUES (
'2000', 'titre de la fiche', 'description de la fiche', 'url de la fiche', '6', '9', '3', '13', '17', '20', '38', '38', CURTIME( ) , '38', CURTIME( ) , '0', '22', '16', '29', 'browser string of file', CURTIME( ) , '31', '36'
);";
		
?>