<?php

// en.php - English strings and titles
// ------------------------------------------------------------------------
// Copyright (c) 2001, 2002 The phpBugTracker Group
// ------------------------------------------------------------------------
// This file is part of phpBugTracker
// Translation extended by Denis Guinnepain
//
// phpBugTracker is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// phpBugTracker is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with phpBugTracker; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// ------------------------------------------------------------------------
// $Id: en.php,v 1.1.1.2 2005/06/03 22:04:12 denis Exp $






$STRING = array(
	//'lang_charset' => 'utf-8',
	'lang_charset' => 'ISO-8859-1',
	'File' => 'File',
	'bad_index' => 'Non modified index because non coherent',
	'nouser' => 'That user for CC does not exist',
	'dupeofself' => 'A bug can\'t be a duplicate of itself',
	'nobug' => 'That bug does not exist',
	'givesummary' => 'Please enter a summary',
	'givedesc' => 'Please enter a description',
	'noprojects' => 'No projects found',
	'totalbugs' => 'Total Bugs',
	'giveemail' => 'Please enter a valid email address',
	'giveemailagain' => 'Please enter again a valid email address',
	'wrong_email'=>"Wrong email address",
	'givelogin' => 'Please enter a login',
	'giveloginagain' => 'Confirm this login',
	'givedomain' => 'Entrer a domain name',
	'loginused' => 'That login has already been used',
	'loginnotused' => 'That login is new, it is necessary to precise a name',
	'confirm_loginused'=>'Confirm again',
	'domainused' => 'This domain name is already in use',
	'DomainCreation' => 'The domain is successfully created, please log again in order changes take effect',
	'newacctsubject' => 'Diamentis Login',
	'newacctmessage' => "Your Diamentis password is %s",
	'newinvitesubject' => 'Invitation sur un domaine Diamentis',
	'newinvitemessage' => "You are invited to participate at the %s domain. To validate the invite, you need to follow this link %s, and identify yourself with login-password. Click then on the Personal Page link. You will find authorized domain list where you can access. Select expected domains and click on Submit",
	'nobugs' => 'No files found',
	'noDomainAvailable'=>"There are no available domains with your current access rights",
	'givename' => 'Please enter a name',
	'giveFirstName' => 'Enter a firstname',
	'giveLastName' => 'Enter an name',
	'optional'=>"optional",
	'multiple_select'=>"Press Ctrl for multiple selection",
	'edit' => 'Edit',
	'addnew' => 'Add new',
	'nooses' => 'No OSes found',
	'giveinitversion' => 'Please enter an initial version for the project',
	'giveversion' => 'Please enter a version',
	'noversions' => 'No versions found',
	'nocomments' => 'No components found',
	'nostatuses' => 'No statuses found',
	'givepassword' => 'Please enter a password',
	'nousers' => 'No users found',
	'bugbadperm' => 'You cannot change this file',
	'bugbadstatus' => 'You cannot go directly to this status',
	'bugbadcomment' => 'You have to add comments if you change the status',
	'bugbadproject' => 'You must be an admin if you want to change the state',
	'bugbadcomment_project' => 'You have to let an additionnal comment if you change the domain',
	'bugbadnum' => 'That bug does not exist',
	'datecollision' => 'Someone has updated this bug since you viewed it.	The bug info has been reloaded with the latest changes.',
	'passwordmatch' => 'Those passwords don\'t match -- please try again',
	'nobughistory' => 'There is no history for that bug',
	'logintomodify' => 'You must be logged in to modify this bug',
	'dupe_attachment' => 'That attachment already exists for this bug',
	'give_attachment' => 'Please specify a file to upload',
	'no_attachment_save_path' => 'Couldn\'t find where to save the file!',
	'attachment_path_not_writeable' => 'Couldn\'t create a file in the save path',
	'attachment_move_error' => 'There was an error moving the uploaded file',
	'bad_attachment' => 'That attachment does not exist',
	'attachment_too_large' => 'The file you specified is larger than '.number_format(ATTACHMENT_MAX_SIZE).' bytes',
	'bad_permission' => 'You do not have the permissions required for that function',
	'noseverities' => 'No severities found',
	'project_only_all_groups' =>'You cannot choose specific groups when "All Groups" is chosen',
	'previous_bug' => 'Previous',
	'next_bug' => 'Next',
	'already_voted' => 'You have already voted for this bug',
	'too_many_votes' => 'You have reached the maximum number of votes per user',
	'no_votes' => 'There are no votes for this bug',
	'user_filter' => array(
		0 => 'All users',
		1 => 'Active users',
		2 => 'Inactive users'),
	'dupe_dependency' => 'That bug dependency has already been added',
	'image_path_not_writeable' => 'The subdirectory "jpgimages" is not writeable by the web process, so the summary image can not be rendered',
	'password_changed' => 'Your password has been changed',
	'prefs_changed' => 'Your preferences have been changed',
	'databaselist' => 'Database list',
	'database' => 'Database',
	'databases' => 'Databases',
	'name' => 'Name',
	'description' => 'Description',
	'withSequence' => 'Respect states order',
	'active'=>'Active',
	'share_view_all'=>'Authorize all visitors to read your domain',
	'share_edit_log'=>'Authorize all identified users to edit domain files',
	'share_struct'=>'Authorize the inheritance of your domain configuration',
	'authorize_request'=>'Authorize users to perform an access domain request',
	'share_new'=>'Authorize an anonymous user to create a file on your domain',
	'submit_invited'=>'Invited users only',
	'sortorder' => 'Sort order',
	'suredeletedb' => 'Are you sure to delete this database?',
	'suredeletesite' => 'Are you sure to delete this site?',
	'delete' => 'Delete',
	'version' => 'Version',
	'addnewsite' => 'Add new Site',
	'sitelist' => 'Site list',
	'sites' => 'Sites',
	'eMail_Comment1' => 'THIS MESSAGE WAS GENERATED BY THE BUGTRACKER SOFTWARE PLEASE DO NOT REPLY',
	'eMail_Comment2' => 'INSTEAD FOLLOW BUG\'S URL BELOW IN ORDER TO DETAIL BUG:',
	'eMail_access_subject' => 'Access rights request',
	'eMail_access_content' => ' wishes to access your managed domain. This message is also transmitted to other managers, if any. Click on the following link and identify yourself in order to attribute him the correct rights : ',
	'eMail_access_subject_remove' => 'unsubscribe',
	'eMail_access_content_remove' => ' wishes to no more access your managed domain. This message is also transmitted to other managers, if any. Click on the following link if you want to prevent a new access request : ',
	'eMail_moved_in_file' => "File %s is out of your domain",
	'eMail_moved_out_file' => "File %s is in your domain",
	'eMail_moved_file_by_user' => "The file %s has been move to another domain by %s. For more details, click on the following link and identify yourself : ",
	'back_to_bug' => "Back to file",
	'or' => " or ",
	'file_validation' => " your file has been successfully recorded with the id : ",
	'field_edition' => "Edition des champs",
	'missing_feature' => "Contact uzoulabs.com to get this feature",
	'advanced' => "Advanced...",
	'define_visibility' => "Define states where the field is masked",
	'define_followers' => "Define states which are accessible from that state",
	
	/////////////////////////////////////////////////////////////////////////////
	// about dynamic fields
	/////////////////////////////////////////////////////////////////////////////
	'configure_public_fields' => "Configure root fields",
	'configure_project_fields' => "Configure fields",
	'export_domain' => "Export the domain",
	'import_domain' => "Import the domain",
	'import_warning'=>"This feature is not yet validated, don't use it, for sure.",
	'invite_sby'=>'Invite somebody...',
	'domain_name'=>'Domain name',
	'end_import'=>"Importation is done",
	'choose_backup_file' => 'Choose the backup file name of your domain',
	'File'=>'File',
	'import_too_large' => 'The file is bigger than '.number_format(ATTACHMENT_MAX_SIZE*10).' bytes',
	'import_problem'=>"Problems, you were aware! ",
	'alert_manage_request'=>"These requests are managed by the choosen user or the sysAdmin",
	'warning_down_invite'=>"You are about tou remove all rights for this user on this domain. He could see no more except if an option allows it.",
	'warning_up_invite'=>"You are about to simulate a domain request for a user.",
	'warning_down_request'=>"You are about to cancel a domain access request made by a user",
	'warning_up_request'=>"You are about to give read rights",
	'warning_down_view'=>"You are about to remove read rights",
	'warning_up_view'=>"You are about to give edit rights",
	'warning_down_edit'=>"You are about to remove edit rights",
	'warning_up_edit'=>"You are about to give admin rights",
	'warning_down_admin'=>"You are about to remove admin rights, this impacts that page and assignations for the creation of each file, do you confirm?",
	'user_requests'=>'Those users have accepted or wished the domain access',
	'user_invited'=>'Those users have the ability to access the domain',
	'user_with_view'=>'Those users can view the domain',
	'user_with_edit'=>'Those users can modify the files on this domain',
	'user_with_admin'=>'Those users can configure the domain and will be assigned by default at the file creation',	
	'access_domain'=>"Select domains you wish to access",
	'accept'=>'Accept',
	'refuse'=>'Refuse',
	'add_new_field_msg' => 'Add a new field',
	'select_a_field_to_edit' => 'Select a field to edit : ',
	'type_of_field' => 'Type of field',	
	'edit_selectbox' => 'Edit selectbox values',
	'edit_this_field' => 'Edit this field',
	'add_new_selectbox_value' => 'Add a new value',
	'unable_to_delete_selectbox_value' => 'Unable to delete the selectbox value because it is still in use by at least a file.',
	'unable_to_delete_selectbox_value2' => 'Unable to delete the selectbox value because it is still in use in the %s domain.',
	'unable_to_delete_selectbox_value3' => 'Unable to delete the selectbox value for an unknown reason.',
	'selectbox_deletion_successful' => 'Selectbox value deletion succeeded.',
	'no_result' => 'No rsult.',
	'choose_a_project_for_advanced_search' => 'Choose a domain for an advanced search',
	'choose_a_parent_project' => 'Choose a parent domain that you wish to inherate all fields',
	
	// some warnings
	'warning_sv_must_not_be_used' => 'Warning : this selectbox value must not be used to be removed.',
	'warning_no_html' => 'Warning : no HTML markup',
	'warning_interval_limited' => 'Warning : limited from %s to %s',
	'warning_create_field_cannot_be_cancelable' => 'Warning : field creation can not be cancelled.',
	
	// some text for forms
	'YES' => 'yes',
	'NO' => 'no', 
	'none' => 'none', 
	'PreviousPage' => 'Previous page',
	'NextPage' => 'Next page',
	'no_selectbox_value' => 'No selectable value',
	'delete' => 'delete',
	'del' => 'del.',
	'impossible' => 'Impossible',
	'do_you_want_to_continue' => 'Do you want to continue ?',
	'cancel' => 'Cancel',
	'back' => 'Back',
	'create_field' => 'Create this field',
	'reset' => 'Reset',
	'search' => 'Search',
	'no_selected_value' => 'No selected value',
	'comparison' => 'Comparison',
	'disabled' => 'disable',
	'meet_all_conditions' => 'Meet all conditions',
	'statistics' => 'Display the repartition',
	'title_stat' => 'Repartition according to ',
	'weighted' => 'weighted by ',
	'nobody' => 'nobody',
	'order_by_field_name' => 'order by',
	'sort_order' => 'Sort order',
	'asc' => 'increasing',
	'desc' => 'decreasing',
	'nb_of_files_found' => 'file(s) found',
	'bytes' => 'bytes',
	'undefined' => 'indefined',
	'description_of_file' => 'File Description',
	'file' => 'file',
	'said' => 'said', 
	'who' => 'Who',
	'what' => 'What',
	'old_value' => 'Old value',
	'new_value' => 'New value',
	'when' => 'When',
	'add_dep#' => 'Add a dependency towards a file ',
	'del_dep#' => 'Delete a dependency towards a file ',
	'add_contacts' => 'Add contact(s)',
	'del_contacts' => 'Delete contact(s)',
	'self_dependency_forbidden' => 'Self dependency is forbidden.',
	'select_project_to_enter_a_file' => 'Select first a domain to create a file.',
	'undefined' => 'Undefined', 
	'name' => 'Name', 
	'description' => 'Description',
	'active' => 'Active',
	'sequence' => 'Sequence',
	'add_new_project' => 'Add a new Domain',
	'close' => 'Close',
	'endOfFile' => 'End of file',
	
	// for file selection
	'select_all_files' => 'Select all files',
	'unselect_all_files' => 'Unselect all files',
	'check_all_files' => 'Check all these files',
	'uncheck_all_files' => 'Uncheck all these files',
	'all_files_are_selected' => 'All files from the last query are selected.',
	'all_files_are_unselected' => 'All files from the last query are unselected.',
	'unable_to_do_action_because_no_file_is_selected' => 'Unable to do an action because no file is selected',
	'remember_selection' => 'Remember my selection',
	'erase_selection' => 'Forget my selection',
	'SaveListAs' => 'Save my selection as ',
	'Save' => 'Save',
	'remember' => 'Remember',
	'erase' => 'Erase',
	
	// action list
	'action' => 'Action',
	'action_list' => array(
		'project_status' => 'Domain status',
		'send_message' => 'Send a message',
		'test_action' => 'Test action'
	),
	
	// for comparisons
	'comparison_type_name' => array(
		'eq' => "equal", // equal
		'ne' => "not equal", // not equal
		'in' => "between", // in an array of values
		'ni' => "not between", // not in an array of values
		'gt' => "greater", // greater than
		'lt' => "lesser", // lesser than
		'ge' => "greater or equal", // greater or equal
		'le' => "lesser or equal", // lesser or equal
		'like' => 'like',
		'one_element' => 'one word among',
		'one_word' => 'one of the words',
		'all_words' => 'all words'
	),
	
	'MAIL' => array( // array of strings for the email templates
		'new_file' => 'New file',
		'changed_file' => 'Changed file'
	),
	
	'selectbox' => array(
		'value' => 'Value',
		'description' => 'Description',
		'order' => 'Order',
		'closed' => 'Closed Status',
		'sequenceFree' => 'Sequence Free',
		'expanded' => 'Expanded when edit',
		'hidden' => 'Hidden',
		'reserved' => 'Reserved'
	),
	
	'properties' => array(
		'maxlen' => 'Max length',
		'int_size' => 'Digits before the decimal point', 
		'decimal_size' => 'digits after the decimal point', 
		'read_only' =>'Read only in the form', 
		'declare' =>'Visible at the file declaration', 
		'hidden' =>'hidden for users', 
		'dashAfter' =>'Followed by a separator line', 
		'label' =>'section title (read-only + carriage return)', 
		'unique' => 'Unique values', 
		'internal_system_use' => 'Warning : field used by the system', 
		'highlight_url' => 'Highlight URL', 
		'RefSelectBox' => 'Choose the reference field',		
		'time_type' => 'Time type',		
	),
	
	'FIELD_CONF' => array(
		'Title' => array(
			'field_conf_id' => 'ID',
			'title' => 'Title',
			'field_type_title' => 'Type', // added here for convenience
			'description' => 'Description',
			'default_value' => 'Default value',
			'edit_order' => 'Order (when editing)',
			'list_order' => 'Order (when listing)',
			'properties' => 'Properties',
			'created_by' => 'Created by',
			'created_date' => 'Creation date',
			'last_modified_by' => 'Modified by',
			'last_modified_date' => 'Modification date',
			'type' => 'Type'
		),
		'Description' => array(
			'field_conf_id' => 'Field configuration Identifier',
			'title' => 'Field title',
			'field_type_title' => 'Field type',
			'description' => 'Description of the field',
			'default_value' => 'Field default value',
			'edit_order' => 'Display order when editing the file',
			'list_order' => 'Display order when listing files',
			'properties' => 'Field properties',
			'created_by' => 'Field created by',
			'created_date' => 'Field creation date',
			'last_modified_by' => 'Modified by',
			'last_modified_date' => 'Modification date',
			'type' => 'Type'
		)
	),

	'QUERY' => array(
		'opt_All' => 'All',
		'Project' => 'Project',
		'Version' => 'Version',
		'Component' => 'Component',
		'Status' => 'Status',
		'Resolution' => 'Resolution',
		'OpSys' => 'Level',
		'Priority' => 'Priority',
		'Severity' => 'Severity',
		'Database' => 'Database',
		'ReportedOnSite' => 'Reported on <br> subsystem',
		'FieldLinkOperator' => "Boolean operator",
		'FieldLinkOperator_comment_AND' => 'AND : Results verify ALL the criteria of this line.',
		'FieldLinkOperator_comment_OR' => 'OR : Results verify at least ONE of the criteria of this line.',
		'Summary' => 'Summary',


		'DescriptionEntry' => 'A description entry',
		'SortBy' => 'Sort By',
		'SortBy_BugNumber' => 'Bug Number',
		'SortBy_Severity' => 'Severity',
		'SortBy_Reporter' => 'Reporter',
		'SortBy_Priority' => 'Priority',
		'SortBy_Status' => 'Status',
		'SortAsc' => 'Ascending',
		'SortDesc' => 'Descending',
		'SaveThisQueryAs' => 'Save this query as',
		'ResetBackToDefaultQuery' => 'Reset back to default query',
		'SubmitQuery' => 'Submit query',
		'SavedQueries' => 'Saved Queries',
		'GoToThe' => 'Go to the',
		'AdvancedQueryPage' => 'advanced query page',
		'SimpleQueryPage' => 'simple query page',
		'SureDeleteSavedQuery' => 'Are you sure you want to delete this saved query?',
		'MatchingAs' => 'matching as',
		'MatchingAs_Regexp' => 'regexp',
		'MatchingAs_NotRegexp' => 'not regexp',
		'MatchingAs_Substring' => 'substring',
		'MatchingAs_Exact' => 'exact',
		'eMail_Reporter' => 'Reporter',
		'eMail_AssignedTo' => 'Assigned To',
		'isPie'=>'Visualize with PieCharts',
		'isBar'=>'Visualize with histograms'
	),
	'WRAP' => array(
		'FindBug' => 'Find the file',
		'Home' => 'Home',
		'AddNewBug' => 'Add a new file',
		'QueryBugs' => 'Query files',
		'ViewReports' => 'View Reports',
		'Documentation' => 'Read Documentation',
		'AdminTools' => 'Admin Tools',
		'CreateNewAccount' => 'Create a new Account',
		'CreateNewDomain' => 'Create a domain',
		'Email' => 'Email',
		'Login' => 'Login',
		'DoLogin' => 'Login',
		'BugsAssigned' => 'Files assigned to me',
		'BugsReported' => 'Files reported by me',
		'PersonalPage' => 'Personal Page',
		'Logout' => 'Logout',
		'EmailPassword' => 'Email Password',
		'RememberMe' => 'Remember me'
	),
    'BUGFORM' => array(
        'Project' => 'Domain',
		'Version' => 'Version/Milestone',
		'Summary' => 'Summary',
		'Description' => 'Description',
		'Severity' => 'Severity',
		'Priority' => 'Priority',
		'Site' => 'Subsystem',
		'Database' => 'Support',
		'Component' => 'Component',
		'OS' => 'Level',
		'AddAnother' => 'Add another',
		'Submit' => 'Submit'
        ),
	'BUGDISPLAY' => array(
		'bug_id' => 'ID', // rajout pour test		
		'reporter' => 'Reporter',
		'returnto' => 'Return to',
		'buglist' => 'file list',
		'project' => 'Domain',
		'created' => 'Created',
		'version' => 'Version/Milestone',
		'closedinversion' => 'Closed in Version/Milestone',
		'tobeclosedinversion' => 'To be Closed in Version/Milestone',
		'assignedto' => 'Assigned To',
		'assignedtonobody' => 'Nobody',
		'contact_list' => 'Mailing List',
		'url' => 'link',
		'bugdependency' => 'Dependencies',
		'blocks' => 'Blocks',
		'adddependency' => 'Add a Dependency',
		'removedependency' => 'Remove a Dependency',
		'summary' => 'Summary',
		'status' => 'Status',
		'description' => 'Description',
		'severity' => 'Severity',
		'priority' => 'Priority',
		'component' => 'Component',
		'resolution' => 'Resolution',
		'resolutionnone' => 'None',
		'addcc' => 'Add CC',
		'attachment_file' => 'disk file',
		'attachment_description' => 'Description',
		'removeselectedcc' => 'Remove selected CCs',
		'additionalcomments' => 'Additional Comments',
		'attachment' => 'Attachment',
		'attachments' => 'Attachments',
		'add_attachment_instruction' => 'Enter the disk file name and the description.',
		'attachment_max_size' => 'Max size',
		'createattachment' => 'Create Attachment',
		'suredeleteattachment' => 'Are you sure you want to delete this attachment?',
		'name' => 'Name',
		'size' => 'Size',
		'type' => 'Type',
		//'created' => 'Created',
		'voteforthisbug' => 'Vote for this file',
		'viewvotes' => 'View votes',
		'forthisbug' => 'for this file',
		'viewbugactivity' => 'View file activity',
		'printableview' => 'Printable View',
		'noattachments' => 'No attachments',
		'comments' => 'Comments',
		'postedby' => 'Posted By',
		'date' => 'Date',
		'dateon' => 'On',
		'submit' => 'Submit',
		'submitIdle' => 'Submit (same status)',
		'site' => 'Subsystem',
		'database' => 'support',
		'os' => 'Level',
		'chooseone' => 'Choose One',
		'suppressemail' => 'Do not send emails for current modifications',
		'lastmodifier' => 'Last modified by',
		'last_modified_date' => 'Last modification date',
		'browser_string' => 'Browser string',
		'close_date' => 'Close date',
		'backToBug' => 'Back to file ',
		
		// Memento plus
		'change_assignation' => 'Change assignations',
		'Submition' => 'Modifications submition',
		'Rest' => 'Assignations, Attachements, Contacts and Dependencies',
		'Rest_RO' => 'Attachements, Contacts and Dependencies',
	),
	'USER_PREF' => array(
		'ReceiveNotifications' => 'Receive notifications of file changes via email',
		'ShowSavedQueries' => 'Show saved queries on the homepage',
		'ChangePassword' => 'Change password',
		'EnterNewPassword' => 'Please enter your new password twice below',
		'Password' => 'Password',
		'Verify' => 'Verify',
		'ChangePreferences' => 'ChangePreferences',
		'access_projectSaved' => 'Accessible domains have been modified or admins aware',
		'BugListColumns' => 'Bug List Columns',
		'ChooseFields' => 'Choose the fields you want to see in the bug list',
		'SureDeleteVote' => 'Are you sure you want to delete this vote?',
		'Votes' => 'Votes',
		'Bug' => 'File',
		'When' => 'When',
		'ColumnPreferencesSaved' => 'Your file list column preferences have been saved'
	),
	'INDEX' => array(
		'FiveRecentlySubmitted' => 'Five most recently submitted bugs',
		'FiveRecentlyClosed' => 'Five most recently closed bugs',
		'QuickStats' => 'Quick stats',
		'Status' => 'Status',
		'NumberOfBugs' => '# bugs',
		'SavedQueries' => 'Saved Queries',
		'DefResults' => 'Number of files per page in file list : '
	)
);

// Page titles
$TITLE = array(
	'page_title'=>'Workflow management tool with key performance indicators for a quality process management',
	'enterbug' => 'Enter a File',
	'editbug' => 'Edit File',
	'newaccount' => 'Create a new account',
	'newinvite' => 'Send an invitation',
	'bugquery' => 'File Query',
	'buglist' => 'File List',
	'addcomponent' => 'Add Component',
	'editcomponent' => 'Edit Component',
	'addproject' => 'Add Domain',
	'editproject' => 'Edit Domain',
	'addversion' => 'Add Version/Milestone',
	'editversion' => 'Edit Version/Milestone',
	'project' => 'Domains',
	'os' => 'Level',
	'resolution' => 'Resolutions',
	'status' => 'Statuses',
	'user' => 'Users',
	'home' => 'Home',
	'reporting' => 'Reporting',
	'severity' => 'Severities',
	'group' => 'Groups',
	'bugvotes' => 'File Votes',
	'bughistory' => 'File History',
	'viewbug' => 'View File',
	'addattachment' => 'Add Attachment',
	'accountcreated' => 'Account Created',
	'changessaved' => 'Changes Saved',
	'preferences' => 'User Preferences',
	'usertools' => 'User Tools',
	'edituser' => 'Edit User',
	'adduser' => 'Add User',
	'editstatus' => 'Edit Status',
	'addstatus' => 'Add Status',
	'editseverity' => 'Edit Severity',
	'addseverity' => 'Add Severity',
	'editresolution' => 'Edit Resolution',
	'addresolution' => 'Add Resolution',
	'editos' => 'Edit Operating System',
	'addos' => 'Add Operating System',
	'editgroup' => 'Edit Group',
	'addgroup' => 'Add Group',
	'configuration' => 'Configuration',
	'adddatabase' => 'Add a support',
	'editdatabase' => 'Edit support',
	'database' => 'supports',
	'site' => 'subsystem',
	'add_new_field_to' => 'Add a field to the domain',
	'edit_field' => 'Edit field',
	'edit_selectboxes' => 'Configure selectbox values of the field : ',
	'add_selectbox_into_field' => 'Add a selectbox value for the field',
	'define_general_field_properties' => 'Ddfine general field properties',
	'define_type_dependent_field_properties' => 'Define type dependent field properties',
	'sum_up_new_field_properties' => 'Sum up new field properties',
	'simple_search' => 'Simple search',
	'advanced_search' => 'Advanced search',
	'search_result' => 'Search results',
	'file_insert_into_project' => 'File insertion  fiche in the domain',
	'file_edition' => 'File Edition ',
	'file_consultation' => 'File consultation ',
	'project_properties' => 'Domain properties '
);

// some error msgs	
$ERROR = array(	
	'invalid_date' => 'The date format is not correct. Correct format : dd/mm/yyyy [HH:MM]',
	'reserved_value' => 'The \'%s\' value of the \'%s\' selectbox is reserved.',
	'post_data_lost' => 'The webserver has not got all necessary data to process contact uzoulabs.com for professional support',
	'missing_field_content' => 'All mandatory fields have not been filled'
);
?>