<?php

// newdomain.php - Set up new domain
// ------------------------------------------------------------------------
// Copyright (c) 2001, 2002 The phpBugTracker Group
// Copyright (c) 2004, 2005 David Han Sze Chuen, Denis Guinnepain for Air Liquide Medical Systems (Taema)
// Copyright (c) 2005, 2006, 2015 Denis Guinnepain
 
// ------------------------------------------------------------------------
// This file is part of Diamentis

// Diamentis is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// Diamentis is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with phpBugTracker; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// ------------------------------------------------------------------------

include 'include.php'; 

function do_form() {
	global $db, $t, $_pv, $STRING, $now, $u,$QUERY;
	
	if (NEW_ACCOUNTS_DISABLED) {
		$t->wrap('newaccount-disabled.html');
		return;
	}
    if (!$_pv['project_name'] = trim($_pv['project_name']))
    {
        $error = $STRING['givename'];
    } 
    elseif (!$_pv['project_desc'] = htmlspecialchars(trim($_pv['project_desc']))) 
    {
        $error = $STRING['givedesc'];
    }
    if (!empty($error)) 
    { 
        show_form($error);
	println("error");
	return;
    }

    foreach ($_pv as $k => $v) $$k = $v;
    if (!isset($active))
        $active = 0;
    if (!isset($sequence))
        $sequence = 0;
    if (!isset($share_view_all))
        $share_view_all = 0;
    if (!isset($share_struct))
        $share_struct = 0;
    if (!isset($authorize_request))
        $authorize_request = 0;
    if (!isset($share_new))
        $share_new = 0;
    if (!isset($share_edit_log))
        $share_edit_log = 0;


    $projectid = $db->nextId(TBL_PROJECT);
    $projectTableFileName=TBL_PREFIX . "file_prj_id_" . "$projectid";
    $default_status_id = get_open_status_ids();
    if (count($default_status_id)) 
    {
        reset($default_status_id);
        $default_status_id = current($default_status_id);
    } 
    else 
    {
        $default_status_id = 0;
    }
		
    $sql=sprintf($QUERY['init_file_table'], $projectTableFileName, $default_status_id);
    $res=$db->query($sql);
    if (DB::isError($res)) 
    {
        death("DBerror","file table creation failed at stage 1");
    }
    if ($_pv['list_projects']=="none")
    {
    	$_pv['list_projects']=PUBLIC_PROJECT_ID;
    }
//get all public fields which are non internally used by the system
	$db->query('insert into ' . TBL_PROJECT . " (project_id, project_name, project_desc, active, sequence, share_view_all, share_struct, authorize_request, share_new, share_edit_log, parent_project_id, created_by, created_date, file_table_name)
			values ($projectid , " . $db->quote(stripslashes($project_name)) . ", " . $db->quote(stripslashes($project_desc)) . ", $active, $sequence, $share_view_all, $share_struct, $authorize_request, $share_new, $share_edit_log, " . $_pv['list_projects'] . " , $u, $now, " . $db->quote($projectTableFileName) .")");
    if (DB::isError($res)) 
    {
        death("DBerror","file table creation failed at stage 2");
    }
    $res=array();
    $myMPFile = & new MPFile($projectid);
    $res=$myMPFile->sp_cache;
//add fields to the file table
    if (!empty($res)) 
    {	
	foreach($res as $k => $v) 
	{
            if (!isset($v->internal_system_use) or ($v->internal_system_use==false)) 
	    {
                $myMPFile->alterField($myMPFile->project_field_properties[$k]['field_conf_id'],'create');
            }	
        }
    }
    $ProjectPermAdmin = $db->getOne('select perm_id from ' . TBL_AUTH_PERM . " where perm_name ='Admin'");
    $db->query("insert into " . TBL_PROJECT_PERM . " (project_id, user_id, perm_id) values ('$projectid', $u, $ProjectPermAdmin)");

    $t->assign('message',$STRING['DomainCreation']);
    $t->wrap('newdomainsuccess.html', 'domaincreated');
}

function show_form($error = '') {
	global $t, $_pv,$db;
	
	if (NEW_ACCOUNTS_DISABLED) {
		$t->wrap('newaccount-disabled.html');
	} else {
		//$t->wrap('admin/project-add.html', 'addproject');
		$t->assign('error',$error);//, 'newdomain');
//		$array_rest_pj=explode(',', $restricted_projects);
		foreach($db->getAll("SELECT * FROM " . TBL_PROJECT . " WHERE share_struct<>0" ) as $v) 
		{
//			if (!in_array($v['project_id'], $array_rest_pj))
//			{
				$list_of_project[$v['project_id']] = htmlspecialchars($v['project_name']);
//			}
		}	
		$t->assign('list_of_project', $list_of_project);
		$t->wrap('newdomain.html');//, 'newdomain');
	}
}

if (isset($_pv['do'])) 
{
    switch ($_pv['do']) 
    {
        case 'domain' :
            do_form();
            break;
	default :
            show_form();
	    break;
    }
}
else
{
   show_form();
}

?>
