<?php 
// popup_field_properties.php - Set up properties for a domain
// ------------------------------------------------------------------------
// Copyright (c) 2004, 2005 David Han Sze Chuen, Denis Guinnepain for Air Liquide Medical Systems (Taema)
// Copyright (c) 2005, 2006, 2015 Denis Guinnepain
 
// ------------------------------------------------------------------------
// This file is part of Diamentis

// Diamentis is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// Diamentis is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with phpBugTracker; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// ------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// INCLUDES
////////////////////////////////////////////////////////////////////////////////
include 'include.php';
////////////////////////////////////////////////////////////////////////////////
// INCLUDES
////////////////////////////////////////////////////////////////////////////////
/**
	With a given field conf id, get necessary data to show field's properties
*/
function show_field_properties($field_conf_id) {
	global $db, $t;
	
	$toWrap = "popup_field_properties.html";
	
	$field_conf_id = intval($field_conf_id);
	$project_id = MPFile::getProject_id_from_Field_Conf($field_conf_id);
	if ($project_id === false) { // if it's a known field
		$t->assign('error', "Unknown field (#$field_conf_id)");		
	} else {
		$mpfile = &new MPFile($project_id);
		
		$field_conf = &$mpfile->project_field_properties;
		$fc = null;
		foreach($field_conf as $v) {
			if ($v['field_conf_id'] == $field_conf_id) {
				$fc = $v;
				break;
			}
		}
		$res = $db->getRow("SELECT first_name, last_name FROM " . TBL_AUTH_USER . " WHERE user_id = " . $db->quote($fc['created_by']));
		$created_by = "$res[first_name] $res[last_name]";
		$res = $db->getRow("SELECT first_name, last_name FROM " . TBL_AUTH_USER . " WHERE user_id = " . $db->quote($fc['last_modified_by']));
		$last_modified_by = "$res[first_name] $res[last_name]";
				
		$t->assign('created_by', $created_by);
		$t->assign('last_modified_by', $last_modified_by);
		$t->assign('mpfile', $mpfile);
		$t->assign('fc', $fc);		
	}	
	$t->wrap($toWrap, '', true);
} // end of show_field_properties($field_conf_id)
////////////////////////////////////////////////////////////////////////////////
// CODE
////////////////////////////////////////////////////////////////////////////////
switch($op) {
	case 'show' :
		if (isset($_GET['fid'])) {
			show_field_properties(intval($_GET['fid']));
			return;
		}		
	default :
		$t->assign('error', "Access unavailable.");
		$t->wrap("popup_field_properties.html", '', true);
		break;
}

?>