<?php

include_once("include.php");
include_once("inc/func_html.inc.php");


// Functions
function getPostTxt($txt_name) {
    global $no_strip;
    if (isset($_POST[$txt_name])) {
        $txt = $_POST[$txt_name];
        $txt = stripslashes($txt);
        if (!$no_strip) {
            println("Strip tags");
            $txt = strip_tags($txt);
        } else println("No HTML tags stripping.");
        return $txt;
    } else
        return null;
} // end of getPostTxt($txt_name)
// //////////////////////////////////////////////////////////////////////////////
println("<b>Test workshop</b>");
hr();
// //////////////////////////////////////////////////////////////////////////////
// print DEBUG data
// //////////////////////////////////////////////////////////////////////////////
$getvars = "";
foreach($_GET as $k => $v) {
    if ($k != "DEBUG")
        $getvars .= "$k=$v&";
} 

if (isset($_GET['DEBUG'])) {
    // println("_REQUEST");
    // printarray($_REQUEST);
    hr();
    println("_GET");
    printarray($_GET);
    hr();
    println("_POST");
    printarray($_POST);
    println("<a href=\"{$_SERVER['PHP_SELF']}?{$getvars}\">Hide DEBUG data</a>");
    $getvars .= "DEBUG=1&";
} else {
    println("<a href=\"{$_SERVER['PHP_SELF']}?{$getvars}DEBUG=1&\">Print DEBUG data</a>");
} 
hr();
// //////////////////////////////////////////////////////////////////////////////
// Select what to test :
// //////////////////////////////////////////////////////////////////////////////
// what is doable ? here are the default tests
$do = array();
$do['SQL_form'] = "SQL query";
$do['URL_RAW_encode'] = "URL raw encoding";
$do['REGEXP_test'] = 'RegExp Test';
$do['MPSubProperty_trial'] = "MPSubProperty class";
$do['MPFile::getProject_id()_trial'] = "MPFile::getProject_id()";
$do['MPFile::getProjectData()_trial'] = "MPFile::getProjectData()";
$do['MPFile::getFieldsProperties()_trial'] = "MPFile::getFieldsProperties()";
$do['MPFile::getSelectBoxData()_trial'] = 'MPFile::getSelectBoxData()';
$do['Transfer_M_to_MPlus'] = 'Transfer M/M+';
$do['MPFile::getFiles()_trial'] = 'MPFile::getFiles() and MPFile::getField()';
$do['array_intersect_key_trial'] = 'function array_intersect_key($array1, $array2)';
$do['MPFile::createField()_trial'] = 'MPFile::createField()';
$do['MPFile::insertFile()_trial'] = 'MPFile::insertFile()';
$do['MPFile::alterFieldConf()_trial'] = 'MPFile::alterFieldConf() and alterSelectBoxValue';
$do['phpinfo_test'] = 'PHP Info';
$do['server_vars'] =  '$_SERVER vars';
$do['checksyntax_trial'] = 'check php syntax';

// what to do ?
$dont = array();
foreach($do as $k => $v) {
    $toDo = "{$_SERVER['PHP_SELF']}?{$getvars}{$k}";
    if (isset($_GET[$k]) && $_GET[$k] == '1') {
        println("<a href=\"{$toDo}=0&\">Hide test : " . $do[$k] . "</a>");
    } else {
        println("Print test : <a href=\"{$toDo}=1&\">" . $do[$k] . "</a>");
        $do[$k] = false;
    } 
} 
hr();
// commun var
$no_strip = isset($_GET['no_strip'])? true : false;
// //////////////////////////////////////////////////////////////////////////////
// SQL FORM
// //////////////////////////////////////////////////////////////////////////////
if (!empty($do['SQL_form'])) {
    // prepare form
    $default_table = TBL_PREFIX ."field_conf"; 
    // $default_query = "SELECT * FROM $default_table;";
    $default_query = "";
    $sql_query_name = 'query';

    if (isset($_POST[$sql_query_name])) {
        $sql = $_POST[$sql_query_name];

        $sql = stripslashes($sql);

        if (!$no_strip) {
            println("Strip HTML tags");
            $sql = strip_tags($sql);
        } else println("No HTML tags stripping.");
    } else $sql = null; 
    // prepare form
    form('sql_form', $_SERVER['PHP_SELF'] . "?$getvars" . (($no_strip)? 'no_strip&': ''));
    println("Write your sql query : ");
    textarea($sql_query_name, 80, 10, (is_null($sql))? $default_query : $sql); 
    // hiddenbutton('status', 'do_query');
    br();

    submitbutton('Submit');
    nspace(4);
    resetbutton('Reset');
    closeform(); 
    // is there a query to do ?
    if ($sql != null) {
        $sql = trim($sql);

        println("Request sent : " . nl2br(htmlspecialchars($sql)) . "<BR>");

        $res = &$db->query($sql);

        if (DB::isError($res)) {
            echo("ERROR<br>" . $res->getMessage());
        } else {
            // so, an update or insert command was executed
            if (get_class($res) != "db_result") {
                echo("Affected rows : " . $db->affectedRows() . "<br>");
            } else {
                /*
				echo "Tableinfo : ";
				printarray($res->tableInfo(DB_TABLEINFO_ORDER));
				echo "Numrows : " . $res->numRows() . "<br>";
				*/

                $tab = fetchAll($res, true);
                println("Result : ");
                printarray($tab);
            } 
        } 
    } 
    hr();
} 
// //////////////////////////////////////////////////////////////////////////////
// RAW URL ENCODE FORM
// //////////////////////////////////////////////////////////////////////////////
if (!empty($do['URL_RAW_encode'])) {
    // prepare form
    $default_url = $_SERVER['PHP_SELF'];
    $url_query_name = "rawurl_txtarea";
    $url = "";
	
	if (isset($_POST[$url_query_name])) {
        $url = $_POST[$url_query_name];
        $url = stripslashes($url);
        if (!$no_strip) {
            println("Strip tags");
            $url = strip_tags($url);
        } else println("No HTML tags stripping.");
    } else $url = null; 
    // prepare form
    form('url_form', $_SERVER['PHP_SELF'] . "?$getvars" . (($no_strip)? 'no_strip&': ''));
    println("Write your URL to encode : ");
    textarea($url_query_name, 80, 3, (is_null($url))? $default_url : $url);
    br();

    submitbutton('Submit');
    nspace(4);
    resetbutton('Reset');
    closeform(); 
    // is there an url to encode ?
    if ($url != null) {
        $url = trim($url);

        println("URL sent : " . $url);
        $temp = rawurlencode($url);
        println("raw encoded URL : $temp");
        $temp = rawurldecode($url);
        println("raw decoded URL : $temp");
        br();
    } 
    hr();
} 
// //////////////////////////////////////////////////////////////////////////////
// REGEXP TESTER
// //////////////////////////////////////////////////////////////////////////////
if (!empty($do['REGEXP_test'])) {
    // prepare form
    $form_name = "REGEXP_test_trial";
    $txt_query_name = "{$form_name}_txt";
    $txt_query_name2 = "{$form_name}_txt2";
    $txt_input_msg = "Write a regular expression : ";
    $txt_input_msg2 = "Write a test string : ";

    $txt_default = "/\/([^\/]+\/)+/i";
	$txt_default2 = $_SERVER['PHP_SELF'];

    $txt = getPostTxt($txt_query_name);
    $txt2 = getPostTxt($txt_query_name2); 
    // prepare form
    form($form_name, $_SERVER['PHP_SELF'] . "?$getvars" . (($no_strip)? 'no_strip&': ''));
    println($txt_input_msg);
    text($txt_query_name, ($txt == null)?$txt_default:$txt);
    br();
    println($txt_input_msg2);
    text($txt_query_name2, ($txt2 == null)?$txt_default2:$txt2);
    br();

    submitbutton('Submit');
    nspace(4);
    resetbutton('Reset');
    closeform(); 
    // is there an action to do ?
    if ($txt != null) {
	
		//$matches = array();
        // $regexp = stripslashes($txt);
		$regexp = $txt;
		println("regexp = " . htmlspecialchars($regexp));
		println("text = ". htmlspecialchars($txt2));
		$res = preg_match($regexp, $txt2, $matches);
		println("preg_match = $res\n<br>\nmatches = <br>\n");
		printarray($matches);
    }
    hr();
} 
// //////////////////////////////////////////////////////////////////////////////
// MPSubProperty test
// //////////////////////////////////////////////////////////////////////////////
if (!empty($do['MPSubProperty_trial'])) {
    // prepare form
    $default_txt = "time_type=date;read_only=yes;internal_system_use=true;  ";
    $form_name = "MPSubProperty_trial";
    $txt_query_name = "MPSubProperty_txtarea";
    $input_msg = "Write your text to construct a MPSubProperty object : ";

    $txt = "";
    if (isset($_POST[$txt_query_name])) {
        $txt = $_POST[$txt_query_name];
        $txt = stripslashes($txt);
        if (!$no_strip) {
            println("Strip tags");
            $txt = strip_tags($txt);
        } else println("No HTML tags stripping.");
    } else $txt = null; 
    // prepare form
    form($form_name, $_SERVER['PHP_SELF'] . "?$getvars" . (($no_strip)? 'no_strip&': ''));
    println($input_msg);
    textarea($txt_query_name, 80, 6, (is_null($txt))? $default_txt : $txt);
    br();

    submitbutton('Submit');
    nspace(4);
    resetbutton('Reset');
    closeform(); 
    // is there an action to do ?
    if ($txt != null) {
        $txt = trim($txt);

        $txt = explode("\n", $txt);
        foreach($txt as $k => $val) {
            if (trim($val)) {
                println("String = '$val'");
                $temp = &new MPSubProperty($val);
                if (!empty($temp)) {
                    println("MPSubProperty object instanciation succeeded.");
                    println("toString() = '" . $temp->toString(false, true) . "'");
                } 
                br();
            } 
        } 
    } 
    hr();
} 
// //////////////////////////////////////////////////////////////////////////////
// MPFile::getProject_id test
// //////////////////////////////////////////////////////////////////////////////
if (!empty($do['MPFile::getProject_id()_trial'])) {
    // prepare form
    $default_txt = "void";
    $form_name = "MPFile_getProject_id()_trial";
    $txt_query_name = "MPFile_getProject_id_txtarea";
    $input_msg = "Write a file_id to know its project_id, <br>or write 'void' in order to get the project_id of the current MPFile object : ";

    $txt = "";
    if (isset($_POST[$txt_query_name])) {
        $txt = $_POST[$txt_query_name];
        $txt = stripslashes($txt);
        if (!$no_strip) {
            println("Strip tags");
            $txt = strip_tags($txt);
        } else println("No HTML tags stripping.");
    } else $txt = null; 
    // prepare form
    form($form_name, $_SERVER['PHP_SELF'] . "?$getvars" . (($no_strip)? 'no_strip&': ''));
    println($input_msg);
    text($txt_query_name, ($txt != null)? $default_txt : $txt);
    br();

    submitbutton('Submit');
    nspace(4);
    resetbutton('Reset');
    closeform(); 
    // is there an action to do ?
    if (!is_null($txt)) {
        if ($txt == "void") {
            $mpfile = &new MPFile(null, true);
            println("Project_id of the current MPFile object : " . $mpfile->getProject_id());
        } else {
            $val = intval($txt);
            if (is_int($val)) {
                $res = MPFile::getProject_id($val);
                if ($res === false)
                    println("<b>No file</b> with file_id = {$val}.");
                else
                    println("Project_id of file $val is : $res");
            } else {
                println("Please, enter a positive integer value or 'void'.");
            } 
        } 
    } 
    hr();
} 
// //////////////////////////////////////////////////////////////////////////////
// MPFile::getProjectData test
// //////////////////////////////////////////////////////////////////////////////
if (!empty($do['MPFile::getProjectData()_trial'])) {
    // prepare form
    $default_sel = "";
    $form_name = "MPFile_getProjectData()_trial";
    $sel_query_name = "{$form_name}_listbox";
    $txt_query_name = "{$form_name}_txt";
    $listbox_input_msg = "Select project fields : ";
    $txt_input_msg = "Write the number of a project_id, or nothing for the public project :";

    $arrayList = array("test1" => "*",
        "test2" => "project_id",
        "project_name",
        "project_desc",
        "active",
        "sequence",
        "created_by",
        "created_date",
        "last_modified_by",
        "last_modified_date"
        );

    $sel = null;
    if (isset($_POST[$sel_query_name])) {
        $sel = $_POST[$sel_query_name];
    } else $sel = null;

    $txt = "";
    if (isset($_POST[$txt_query_name])) {
        $txt = $_POST[$txt_query_name];
        $txt = stripslashes($txt);
        if (!$no_strip) {
            println("Strip tags");
            $txt = strip_tags($txt);
        } else println("No HTML tags stripping.");
    } else $txt = null; 
    // prepare form
    form($form_name, $_SERVER['PHP_SELF'] . "?$getvars" . (($no_strip)? 'no_strip&': ''));
    println($listbox_input_msg);
    listbox($sel_query_name, $arrayList, 1, true);
    br();
    println($txt_input_msg);
    text($txt_query_name, $txt);
    br();

    submitbutton('Submit');
    nspace(4);
    resetbutton('Reset');
    closeform(); 
    // is there an action to do ?
    if (is_array($sel) && count($sel)) {
        if (trim($txt) == '') {
            $txt = null;
        } else {
            $val = intval($txt);
            if (!is_int($val)) {
                println("Please, enter a positive integer value or leave the field empty.");
            } 
        } 

        $temp = array();
        foreach($sel as $k => $v) {
            $temp[] = $arrayList[$v];
        } 
        $sel = $temp;

        if (in_array("*", $sel)) {
            $sel = "*";
        } 

        println("Selection  : ");
        printarray($sel);
        println("Project_id = $val");

        println("Running MPFile::getProjectData().");
        $test = MPFile::getProjectData($val, $sel);
        printarray($test);
    } 
    hr();
} 
// //////////////////////////////////////////////////////////////////////////////
// MPFile::getFieldsProperties test
// //////////////////////////////////////////////////////////////////////////////
if (!empty($do['MPFile::getFieldsProperties()_trial'])) {
    // prepare form
    $default_txt = "";
    $form_name = "MPFile_getFieldsProperties()_trial";
    $txt_query_name = "{$form_name}_txtarea";
    $txt_input_msg = "Write the project_id to get its field properties :";

    $txt = "";
    if (isset($_POST[$txt_query_name])) {
        $txt = $_POST[$txt_query_name];
        $txt = stripslashes($txt);
        if (!$no_strip) {
            println("Strip tags");
            $txt = strip_tags($txt);
        } else println("No HTML tags stripping.");
    } else $txt = null; 
    // prepare form
    form($form_name, $_SERVER['PHP_SELF'] . "?$getvars" . (($no_strip)? 'no_strip&': ''));
    println($txt_input_msg);
    text($txt_query_name, (is_null($txt))? $default_txt : $txt);
    br();

    submitbutton('Submit');
    nspace(4);
    resetbutton('Reset');
    closeform(); 
    // is there an action to do ?
    if (!is_null($txt)) {
        println("Project_id = $txt");
        $test = MPFile::getFieldsProperties($txt, array('assoc' => 'field_name'), true);
        println ("<br>MPFile::getFieldsProperties : ");
        printarray($test);
    } 
    hr();
} 
// //////////////////////////////////////////////////////////////////////////////
// MPFile::getSelectBoxData test
// //////////////////////////////////////////////////////////////////////////////
if (!empty($do['MPFile::getSelectBoxData()_trial'])) {
    // prepare form
    $default_txt = "";
    $form_name = "MPFile::getSelectBoxData()_trial";
    $txt_query_name = "{$form_name}_txtarea";
    $txt_input_msg = "Write the project_id to get its select box properties :";

    println("We test also getField_Conf_id_by_type() using the SELECTBOX_TYPE parameter.");

    $txt = "";
    if (isset($_POST[$txt_query_name])) {
        $txt = $_POST[$txt_query_name];
        $txt = stripslashes($txt);
        if (!$no_strip) {
            println("Strip tags");
            $txt = strip_tags($txt);
        } else println("No HTML tags stripping.");
    } else $txt = null; 
    // prepare form
    form($form_name, $_SERVER['PHP_SELF'] . "?$getvars" . (($no_strip)? 'no_strip&': ''));
    println($txt_input_msg);
    text($txt_query_name, (is_null($txt))? $default_txt : $txt);
    br();

    submitbutton('Submit');
    nspace(4);
    resetbutton('Reset');
    closeform(); 
    // is there an action to do ?
    if ($txt != null) {
        println("Project_id = $txt");
        println ("<br>MPFile::getFieldsProperties() launched.");
        $tab = MPFile::getFieldsProperties($txt);
        println ("<br>MPFile::getField_Conf_id_by_type() launched.");
        $fc_selectbox_ids = MPFile::getField_Conf_id_by_type($tab, $searched_type = SELECTBOX_TYPE, $verbose = true);
        println ("<br>MPFile::getSelectBoxData() launched.");
        $test = MPFile::getSelectBoxData($fc_selectbox_ids, $verbose = true); 
        // println("Selectbox data : ");
        // printarray($test);
    } 
    hr();
} 
// //////////////////////////////////////////////////////////////////////////////
// Transfer database M->M+ : copy Memento usual data model to Memento Plus' model
// //////////////////////////////////////////////////////////////////////////////
if (!empty($do['Transfer_M_to_MPlus'])) {
    // prepare form
    $default_txt = "write yes or no";
    $form_name = "Transfer_M_to_MPlus";
    $txt_query_name = "{$form_name}_txtarea";
    $txt_input_msg = "Do you really want to transfer data from Memento to Memento Plus ? ";

    $txt = "";
    if (isset($_POST[$txt_query_name])) {
        $txt = $_POST[$txt_query_name];
        $txt = stripslashes($txt);
        if (!$no_strip) {
            println("Strip tags");
            $txt = strip_tags($txt);
        } else println("No HTML tags stripping.");
    } else $txt = null; 
    // prepare form
    form($form_name, $_SERVER['PHP_SELF'] . "?$getvars" . (($no_strip)? 'no_strip&': ''));
    println($txt_input_msg);
    text($txt_query_name, (is_null($txt))? $default_txt : $txt);
    br();

    submitbutton('Submit');
    nspace(4);
    resetbutton('Reset');
    closeform(); 
    // is there an action to do ?
    if ($txt != null) {
        $txt = trim($txt);
        println("Answer = $txt");

        switch (strtolower($txt)) {
            case 'no' :
                println("It may be the wise decision ^^;");
                break;
            case 'yes' :
                include_once('inc/func_transfer_M_to_MPlus.inc.php');
                break;
            default :
                println("You don't know what you want ?");
                break;
        } 
    } 
    hr();
} 
// //////////////////////////////////////////////////////////////////////////////
// MPFile::getFile test
// //////////////////////////////////////////////////////////////////////////////
if (!empty($do['MPFile::getFiles()_trial'])) {
    // prepare form
    $default_txt = "";
    $form_name = "MPFile::getFiles()_trial";
    $txt_query_name = "{$form_name}_txtarea";
    $txt_input_msg = "Write the file_ids to get their fields values. Ex: 1,2,3.. :";

    $chk_query_msg = "Do you want to use getFields ?";
    $chk_query_name = "{$form_name}_chk";
    $chk_query_value = "true";
    $chk_query_selected = false;

    $txt = "";
    if (isset($_POST[$txt_query_name])) {
        $txt = $_POST[$txt_query_name];
        $txt = stripslashes($txt);
        if (!$no_strip) {
            println("Strip tags");
            $txt = strip_tags($txt);
        } else println("No HTML tags stripping.");
    } else $txt = null; 
    // prepare form
    form($form_name, $_SERVER['PHP_SELF'] . "?$getvars" . (($no_strip)? 'no_strip&': ''));
    println($txt_input_msg);
    text($txt_query_name, (is_null($txt))? $default_txt : $txt);

    br();
    checkbox($chk_query_name, $chk_query_value, $chk_query_selected = ((isset($_POST[$chk_query_name]))? true:false), $cmdtype = 1, $option = '');
    nspace(2);
    println($chk_query_msg);
    br();

    submitbutton('Submit');
    nspace(4);
    resetbutton('Reset');
    closeform(); 
    // is there an action to do ?
    if ($txt != null) {
        $ids = explode(',', $txt); 
        // convert txt to int
        foreach($ids as $k => $id) {
            $ids[$k] = intval(trim($id));;
        } 
        // projects needed per id
        $projects = array();
        foreach($ids as $t => $file_id) {
            println("File id = $file_id");
            $project_id = MPFile::getProject_id($file_id);
            if (($project_id == null) || ($project_id === false)) {
                println("Error : file $file_id cannot be found.");
            } else {
                println("Project id = $project_id");
                if (!isset($projects[$project_id])) {
                    $projects[$project_id] = array();
                } 
                $projects[$project_id][] = $file_id;
            } 
        } 
        // for each project
        foreach($projects as $project_id => $tab) {
            println("<h3>Printing files of project $project_id</h3>");
            $mpfile = &new MPFile($project_id);
            println("MPFile object created."); 
            // on its files
            foreach($tab as $k => $file_id) {
                if (isset($_POST[$chk_query_name]) && ($_POST[$chk_query_name] == 'true'))
                    $file_data = $mpfile->getField('*', $file_id, true);
                else
                    $file_data = $mpfile->getFile($file_id, false, true);

                println("<h2>File $file_id data : </h2>");
                printarray($file_data);

                println("In MPFile cache : ");
                $cached_ids = array_keys($mpfile->file_cache);
                printarray($cached_ids);
                hr();
            } 
            hr();
        } 
    } 
    hr();
} 
// //////////////////////////////////////////////////////////////////////////////
// array_intersect_key test
// //////////////////////////////////////////////////////////////////////////////
if (!empty($do['array_intersect_key_trial'])) {
    // test this function array_intersect_key()
    $A = array('a' => 1,
        'b' => 2,
        'c' => 3,
        0 => 10,
        2 => 20,
        3 => 50
        );

    $B = array('a' => 5, 
        // 'b' => 6,
        'c' => 7,
        0 => 10, 
        // 2 => 20,
        3 => 50,
        10 => 1,
        'B' => 11
        );
    println("A");
    printarray($A);
    println("B");
    printarray($B);
    println("Test this function array_intersect_key(). <br>
	Return an array of the array1 elements whose index value is in array2 index values ");
    $res = array_intersect_key($A, $B);
    printarray($res);

    hr();
} 
// //////////////////////////////////////////////////////////////////////////////
// MPFile::createField test
// //////////////////////////////////////////////////////////////////////////////
if (!empty($do['MPFile::createField()_trial'])) {
    // prepare form
    $form_name = "MPFile_createField()_trial";
    $txt_query_name = "{$form_name}_txt";
    $txt_query_name2 = "{$form_name}_txt2";
    $txt_input_msg = "Write a field_conf id : ";
    $txt_input_msg2 = "Write the number of a project_id, or nothing for the public project :";

    $test_table = "test";

    $txt_default = "1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23";
    $txt_default2 = "0";

    $txt = getPostTxt($txt_query_name);
    $txt2 = getPostTxt($txt_query_name2); 
    // prepare form
    form($form_name, $_SERVER['PHP_SELF'] . "?$getvars" . (($no_strip)? 'no_strip&': ''));
    println($txt_input_msg);
    text($txt_query_name, ($txt == null)?$txt_default:$txt);
    br();
    println($txt_input_msg2);
    text($txt_query_name2, ($txt2 == null)?$txt_default2:$txt2);
    br();

    submitbutton('Submit');
    nspace(4);
    resetbutton('Reset');
    closeform(); 
    // is there an action to do ?
    if ($txt != null) {
        $project_id = intval($txt2);
        println("Creation of MPFile object.");
        $mpfile = &new MPFile($project_id); 
        // we hack this part to prevent the prog to modify the real table
        $mpfile->project_data['file_table_name'] = 'test';
        if (empty($mpfile)) {
            println("Object construction failed. Verify that Project_id is correct.");
        } else {
            $sql = "DROP TABLE IF EXISTS $test_table;";
            $res = $db->query($sql);
            $sql = "CREATE TABLE `$test_table` (
            	`id` int(10) unsigned NOT NULL default '0',
            	PRIMARY KEY  (`id`)
            	) TYPE=MyISAM";
            $res = $db->query($sql);
            
            println("Structure of the test table ($test_table) :");
            $sql = "show create table $test_table";
            $res = $db->query($sql);
            if (DB::isError($res)) {
                death("DB ERROR", "MPFile::createField()<br>" . $res->getMessage());
            } 
            printarray(fetchAll($res)); 
            // ///////////////////
            $fids = explode(",", $txt);
            foreach($fids as $k => $v) {
                $field_conf_id = intval($v);
                println("createField() $v : ");
                $mpfile->createField($field_conf_id, true);
            } 
            // ///////////////////
            println("Here's the new structure of the test table ($test_table) :");
            $sql = "show create table $test_table";
            $res = $db->query($sql);
            if (DB::isError($res)) {
                death("DB ERROR", "MPFile::createField()<br>" . $res->getMessage());
            } 
            printarray(fetchAll($res)); 
            // now, delete these fields
            foreach($fids as $k => $v) {
                $field_conf_id = intval($v);
                println("dropField() $v : ");
                $mpfile->dropField($field_conf_id, true);
            } 
            // ///////////////////
            println("Here's the final structure of the test table ($test_table) :");
            $sql = "show create table $test_table";
            $res = $db->query($sql);
            if (DB::isError($res)) {
                death("DB ERROR", "MPFile::createField()<br>" . $res->getMessage());
            } 
            printarray(fetchAll($res));
        } 
    } 
    hr();
} 
// //////////////////////////////////////////////////////////////////////////////
// MPFile::insertFile test
// //////////////////////////////////////////////////////////////////////////////
if (!empty($do['MPFile::insertFile()_trial'])) {
    // prepare form
    $form_name = "MPFile::insertFile()_trial";
    $txt_query_name = "{$form_name}_txt";
    $txt_query_name2 = "{$form_name}_txt2";
    $txt_input_msg = "Write the file_id of a dummy file to insert : ";
    $txt_input_msg2 = "Write the number of a project_id : ";

    $txt_default = "";
    $txt_default2 = "1";

    $txt = getPostTxt($txt_query_name);
    $txt2 = getPostTxt($txt_query_name2); 
    // prepare form
    form($form_name, $_SERVER['PHP_SELF'] . "?$getvars" . (($no_strip)? 'no_strip&': ''));
    println($txt_input_msg);
    text($txt_query_name, ($txt == null)?$txt_default:$txt);
    br();
    println($txt_input_msg2);
    text($txt_query_name2, ($txt2 == null)?$txt_default2:$txt2);
    br();

    submitbutton('Submit');
    nspace(4);
    resetbutton('Reset');
    closeform(); 
    // is there an action to do ?
    if ($txt2 != null) {
        $project_id = intval($txt2);
        println("Creation of MPFile object.");
        $mpfile = &new MPFile($project_id);
        println("Creation of a new file.");

        $field_values = array(); 
        // $field_values['bug_id'] = 2000;
        $field_values['title'] = "titre de la fiche";
        $field_values['description'] = "description de la fiche";
        $field_values['url'] = "url de la fiche";
        $field_values['severity_id'] = 6;
        $field_values['priority'] = 9 ;
        $field_values['status_id'] = 3 ;
        $field_values['resolution_id'] = 13 ;
        $field_values['database_id'] = 17 ;
        $field_values['site_id'] = 20 ;
        $field_values['assigned_to'] = array(38);
        $field_values['created_by'] = 38 ;
        $field_values['created_date'] = 16 ;
        $field_values['last_modified_by'] = 38 ;
        $field_values['last_modified_date'] = 16 ;
        //$field_values['project_id'] = 1 ;
        $field_values['version_id'] = 22 ;
        $field_values['component_id'] = 16 ;
        $field_values['os_id'] = 29 ;
        $field_values['browser_string'] = "browser string of file";
        $field_values['close_date'] = 16 ;
        $field_values['closed_in_version_id'] = 31 ;
        $field_values['to_be_closed_in_version_id'] = 36 ;

        $created_file_id = $mpfile->insertFile($field_values, true);
        println("Retrieving data of the new file with getFile.");
        $file_data = $mpfile->getField("*", $created_file_id, true);
        printarray($file_data);
    } 
    hr();
} 
// //////////////////////////////////////////////////////////////////////////////
// MPFile::alterFieldConf test
// //////////////////////////////////////////////////////////////////////////////
if (!empty($do['MPFile::alterFieldConf()_trial'])) {
	
	println("This test is disabled");
	
	/*
    // prepare form
    $form_name = "MPFile::alterFieldConf()_trial";
    $txt_query_name = "{$form_name}_txt";
    $txt_query_name2 = "{$form_name}_txt2";
    $txt_input_msg = "Write the file_id of a dummy file to insert : ";
    $txt_input_msg2 = "Write the number of a project_id : ";

    $txt_default = "";
    $txt_default2 = "1";

    $txt = getPostTxt($txt_query_name);
    $txt2 = getPostTxt($txt_query_name2); 
    // prepare form
    form($form_name, $_SERVER['PHP_SELF'] . "?$getvars" . (($no_strip)? 'no_strip&': ''));
    println($txt_input_msg);
    text($txt_query_name, ($txt == null)?$txt_default:$txt);
    br();
    println($txt_input_msg2);
    text($txt_query_name2, ($txt2 == null)?$txt_default2:$txt2);
    br();

    submitbutton('Submit');
    nspace(4);
    resetbutton('Reset');
    closeform(); 
    // is there an action to do ?
    if ($txt2 != null) {
		$test_fc = 'test_field_conf'; 
		$test_so = 'test_selectbox_option';
		$test_sv = 'test_selectbox_value';
		
		$project_id = intval($txt2);
        println("Creation of MPFile object.");
        $mpfile = &new MPFile($project_id);
        
		println("The project field conf data will be transfered to the test tables : ");
		println("Test tables : <b>$test_fc, $test_so and $test_sv.</b>");
		
		$field_confs = $mpfile->project_field_properties;
		
		$action = 'insert';
		foreach($field_confs as $fc_k => $field_conf) {
			$selectbox_values = (isset($mpfile->sb_cache[$field_conf['field_conf_id']]))? $mpfile->sb_cache[$field_conf['field_conf_id']] : null; 
			$return = $mpfile->alterFieldConf($field_conf, $selectbox_values, $action, $verbose = true);
			
			println("Result : for the field conf : $field_conf['title']");
			printarray($return);
		}
		
		/*
        $field_values = array(); 
        // $field_values['bug_id'] = 2000;
        $field_values['title'] = "titre de la fiche";
        $field_values['description'] = "description de la fiche";
        $field_values['url'] = "url de la fiche";
        $field_values['severity_id'] = 6;
        $field_values['priority'] = 9 ;
        $field_values['status_id'] = 3 ;
        $field_values['resolution_id'] = 13 ;
        $field_values['database_id'] = 17 ;
        $field_values['site_id'] = 20 ;
        $field_values['assigned_to'] = array(38);
        $field_values['created_by'] = 38 ;
        $field_values['created_date'] = 16 ;
        $field_values['last_modified_by'] = 38 ;
        $field_values['last_modified_date'] = 16 ;
        $field_values['project_id'] = 1 ;
        $field_values['version_id'] = 22 ;
        $field_values['component_id'] = 16 ;
        $field_values['os_id'] = 29 ;
        $field_values['browser_string'] = "browser string of file";
        $field_values['close_date'] = 16 ;
        $field_values['closed_in_version_id'] = 31 ;
        $field_values['to_be_closed_in_version_id'] = 36 ;

        $created_file_id = $mpfile->insertFile($field_values, true);
        println("Retrieving data of the new file with getFile.");
        $file_data = $mpfile->getField("*", $created_file_id, true);
        printarray($file_data);
        */
    //} 
	
    hr();
}
// //////////////////////////////////////////////////////////////////////////////
// PHPINFO
// //////////////////////////////////////////////////////////////////////////////
if (!empty($do['phpinfo_test'])) {
    phpinfo();
    hr();
} 
// //////////////////////////////////////////////////////////////////////////////
// SERVER_VARS
// //////////////////////////////////////////////////////////////////////////////
if (!empty($do['server_vars'])) {
    println("\$_SERVER : ");
	printarray($_SERVER);
    hr();
} 
// //////////////////////////////////////////////////////////////////////////////
// Check syntax
// //////////////////////////////////////////////////////////////////////////////
if (!empty($do['checksyntax_trial'])) {
	if (function_exists('php_check_syntax')) {
		// prepare form
		$default_txt = $_SERVER['PHP_SELF'];
		$form_name = "checksyntax_trial";
		$txt_query_name = "{$form_name}_txtarea";
		$txt_input_msg = "Write the file url to check :";
	
		$txt = getPostTxt($txt_query_name);
		
		// prepare form
		form($form_name, $_SERVER['PHP_SELF'] . "?$getvars" . (($no_strip)? 'no_strip&': ''));
		println($txt_input_msg);
		text($txt_query_name, (is_null($txt))? $default_txt : $txt);
		br();
		submitbutton('Submit');
		nspace(4);
		resetbutton('Reset');
		closeform(); 
		
		// is there an action to do ?
		if ($txt != null) {
			$error_message = "";
			$filename = $txt;
			
			if(!php_check_syntax($filename, &$error_message)) {
			   printf("An error has been found in file %s:\n\n%s\n", $filename, $error_message);
			} else {
			   printf("The syntax of %s is correct.", $filename);
			}
		}
	} else {
		println('Test impossible because the function <i>php_check_syntax()</i> doesn\'t exist in the current PHP engine.');
	}
    hr();
} 
?>